/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.rocksdb;

import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksObject;

public class CompactRangeOptions
extends RocksObject {
    private static final byte VALUE_kSkip = 0;
    private static final byte VALUE_kIfHaveCompactionFilter = 1;
    private static final byte VALUE_kForce = 2;

    public CompactRangeOptions() {
        super(CompactRangeOptions.newCompactRangeOptions());
    }

    public boolean exclusiveManualCompaction() {
        return this.exclusiveManualCompaction(this.nativeHandle_);
    }

    public CompactRangeOptions setExclusiveManualCompaction(boolean bl) {
        this.setExclusiveManualCompaction(this.nativeHandle_, bl);
        return this;
    }

    public boolean changeLevel() {
        return this.changeLevel(this.nativeHandle_);
    }

    public CompactRangeOptions setChangeLevel(boolean bl) {
        this.setChangeLevel(this.nativeHandle_, bl);
        return this;
    }

    public int targetLevel() {
        return this.targetLevel(this.nativeHandle_);
    }

    public CompactRangeOptions setTargetLevel(int n) {
        this.setTargetLevel(this.nativeHandle_, n);
        return this;
    }

    public int targetPathId() {
        return this.targetPathId(this.nativeHandle_);
    }

    public CompactRangeOptions setTargetPathId(int n) {
        this.setTargetPathId(this.nativeHandle_, n);
        return this;
    }

    public BottommostLevelCompaction bottommostLevelCompaction() {
        return BottommostLevelCompaction.fromRocksId(this.bottommostLevelCompaction(this.nativeHandle_));
    }

    public CompactRangeOptions setBottommostLevelCompaction(BottommostLevelCompaction bottommostLevelCompaction) {
        this.setBottommostLevelCompaction(this.nativeHandle_, bottommostLevelCompaction.getValue());
        return this;
    }

    public boolean allowWriteStall() {
        return this.allowWriteStall(this.nativeHandle_);
    }

    public CompactRangeOptions setAllowWriteStall(boolean bl) {
        this.setAllowWriteStall(this.nativeHandle_, bl);
        return this;
    }

    public int maxSubcompactions() {
        return this.maxSubcompactions(this.nativeHandle_);
    }

    public CompactRangeOptions setMaxSubcompactions(int n) {
        this.setMaxSubcompactions(this.nativeHandle_, n);
        return this;
    }

    private static native long newCompactRangeOptions();

    @Override
    protected final native void disposeInternal(long var1);

    private native boolean exclusiveManualCompaction(long var1);

    private native void setExclusiveManualCompaction(long var1, boolean var3);

    private native boolean changeLevel(long var1);

    private native void setChangeLevel(long var1, boolean var3);

    private native int targetLevel(long var1);

    private native void setTargetLevel(long var1, int var3);

    private native int targetPathId(long var1);

    private native void setTargetPathId(long var1, int var3);

    private native int bottommostLevelCompaction(long var1);

    private native void setBottommostLevelCompaction(long var1, int var3);

    private native boolean allowWriteStall(long var1);

    private native void setAllowWriteStall(long var1, boolean var3);

    private native void setMaxSubcompactions(long var1, int var3);

    private native int maxSubcompactions(long var1);

    public static enum BottommostLevelCompaction {
        kSkip(0),
        kIfHaveCompactionFilter(1),
        kForce(2);

        private final byte value;

        private BottommostLevelCompaction(byte by) {
            this.value = by;
        }

        public byte getValue() {
            return this.value;
        }

        public static BottommostLevelCompaction fromRocksId(int n) {
            switch (n) {
                case 0: {
                    return kSkip;
                }
                case 1: {
                    return kIfHaveCompactionFilter;
                }
                case 2: {
                    return kForce;
                }
            }
            return null;
        }
    }
}

