/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.fusesource.leveldbjni.internal;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.ArgFlag;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.ClassFlag;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.FieldFlag;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.JniArg;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.JniClass;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.JniField;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.JniMethod;
import org.apache.hadoop.ozone.shaded.org.fusesource.hawtjni.runtime.MethodFlag;
import org.apache.hadoop.ozone.shaded.org.fusesource.leveldbjni.internal.NativeDB;
import org.apache.hadoop.ozone.shaded.org.fusesource.leveldbjni.internal.NativeSlice;

public class Util {
    public static void link(File source, File target) throws IOException {
        if (UtilJNI.ON_WINDOWS == 1) {
            if (UtilJNI.CreateHardLinkW(target.getCanonicalPath(), source.getCanonicalPath(), 0L) == 0) {
                throw new IOException("link failed");
            }
        } else if (UtilJNI.link(source.getCanonicalPath(), target.getCanonicalPath()) != 0) {
            throw new IOException("link failed: " + Util.strerror());
        }
    }

    static int errno() {
        return UtilJNI.errno();
    }

    static String strerror() {
        return Util.string(UtilJNI.strerror(Util.errno()));
    }

    static String string(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return new String(new NativeSlice(ptr, UtilJNI.strlen(ptr)).toByteArray());
    }

    @JniClass(flags={ClassFlag.CPP})
    static class UtilJNI {
        @JniField(flags={FieldFlag.CONSTANT}, accessor="1", conditional="defined(_WIN32) || defined(_WIN64)")
        static int ON_WINDOWS;

        UtilJNI() {
        }

        @JniMethod(flags={MethodFlag.CONSTANT_INITIALIZER})
        private static final native void init();

        @JniMethod(conditional="!defined(_WIN32) && !defined(_WIN64)")
        static final native int link(@JniArg(cast="const char*") String var0, @JniArg(cast="const char*") String var1);

        @JniMethod(conditional="defined(_WIN32) || defined(_WIN64)")
        static final native int CreateHardLinkW(@JniArg(cast="LPCWSTR", flags={ArgFlag.POINTER_ARG, ArgFlag.UNICODE}) String var0, @JniArg(cast="LPCWSTR", flags={ArgFlag.POINTER_ARG, ArgFlag.UNICODE}) String var1, @JniArg(cast="LPSECURITY_ATTRIBUTES", flags={ArgFlag.POINTER_ARG}) long var2);

        @JniMethod(flags={MethodFlag.CONSTANT_GETTER})
        public static final native int errno();

        @JniMethod(cast="char *")
        public static final native long strerror(int var0);

        public static final native int strlen(@JniArg(cast="const char *") long var0);

        static {
            NativeDB.LIBRARY.load();
            UtilJNI.init();
        }
    }

    @JniClass(name="leveldb::Env", flags={ClassFlag.CPP})
    static class EnvJNI {
        EnvJNI() {
        }

        @JniMethod(cast="leveldb::Env *", accessor="leveldb::Env::Default")
        public static final native long Default();

        @JniMethod(flags={MethodFlag.CPP_METHOD})
        public static final native void Schedule(long var0, @JniArg(cast="void (*)(void*)") long var2, @JniArg(cast="void *") long var4);

        static {
            NativeDB.LIBRARY.load();
        }
    }
}

