/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.x509;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Collection;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.x509.NoSuchParserException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.x509.X509StreamParserSpi;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.x509.X509Util;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.x509.util.StreamParser;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.x509.util.StreamParsingException;

public class X509StreamParser
implements StreamParser {
    private Provider _provider;
    private X509StreamParserSpi _spi;

    public static X509StreamParser getInstance(String string) throws NoSuchParserException {
        try {
            X509Util.Implementation implementation = X509Util.getImplementation("X509StreamParser", string);
            return X509StreamParser.createParser(implementation);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchParserException(noSuchAlgorithmException.getMessage());
        }
    }

    public static X509StreamParser getInstance(String string, String string2) throws NoSuchParserException, NoSuchProviderException {
        return X509StreamParser.getInstance(string, X509Util.getProvider(string2));
    }

    public static X509StreamParser getInstance(String string, Provider provider) throws NoSuchParserException {
        try {
            X509Util.Implementation implementation = X509Util.getImplementation("X509StreamParser", string, provider);
            return X509StreamParser.createParser(implementation);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchParserException(noSuchAlgorithmException.getMessage());
        }
    }

    private static X509StreamParser createParser(X509Util.Implementation implementation) {
        X509StreamParserSpi x509StreamParserSpi = (X509StreamParserSpi)implementation.getEngine();
        return new X509StreamParser(implementation.getProvider(), x509StreamParserSpi);
    }

    private X509StreamParser(Provider provider, X509StreamParserSpi x509StreamParserSpi) {
        this._provider = provider;
        this._spi = x509StreamParserSpi;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public void init(InputStream inputStream) {
        this._spi.engineInit(inputStream);
    }

    public void init(byte[] byArray) {
        this._spi.engineInit(new ByteArrayInputStream(byArray));
    }

    public Object read() throws StreamParsingException {
        return this._spi.engineRead();
    }

    public Collection readAll() throws StreamParsingException {
        return this._spi.engineReadAll();
    }
}

