/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.ContentSigner;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.OperatorStreamException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.RuntimeOperatorException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.jcajce.OperatorHelper;

public class JcaContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public JcaContentSignerBuilder(String string) {
        this.signatureAlgorithm = string;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(string);
        this.sigAlgSpec = null;
    }

    public JcaContentSignerBuilder(String string, AlgorithmParameterSpec algorithmParameterSpec) {
        this.signatureAlgorithm = string;
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new IllegalArgumentException("unknown sigParamSpec: " + (algorithmParameterSpec == null ? "null" : algorithmParameterSpec.getClass().getName()));
        }
        PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
        this.sigAlgSpec = pSSParameterSpec;
        this.sigAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, JcaContentSignerBuilder.createPSSParams(pSSParameterSpec));
    }

    public JcaContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentSignerBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JcaContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        try {
            final Signature signature = this.helper.createSignature(this.sigAlgId);
            final AlgorithmIdentifier algorithmIdentifier = this.sigAlgId;
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
            return new ContentSigner(){
                private SignatureOutputStream stream;
                {
                    this.stream = new SignatureOutputStream(signature);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return this.stream.getSignature();
                    }
                    catch (SignatureException signatureException) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("cannot create signer: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static RSASSAPSSparams createPSSParams(PSSParameterSpec pSSParameterSpec) {
        DefaultDigestAlgorithmIdentifierFinder defaultDigestAlgorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier algorithmIdentifier = defaultDigestAlgorithmIdentifierFinder.find(pSSParameterSpec.getDigestAlgorithm());
        AlgorithmIdentifier algorithmIdentifier2 = defaultDigestAlgorithmIdentifierFinder.find(((MGF1ParameterSpec)pSSParameterSpec.getMGFParameters()).getDigestAlgorithm());
        return new RSASSAPSSparams(algorithmIdentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier2), new ASN1Integer(pSSParameterSpec.getSaltLength()), new ASN1Integer(pSSParameterSpec.getTrailerField()));
    }

    private class SignatureOutputStream
    extends OutputStream {
        private Signature sig;

        SignatureOutputStream(Signature signature) {
            this.sig = signature;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(byte[] byArray) throws IOException {
            try {
                this.sig.update(byArray);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new OperatorStreamException("exception in content signer: " + signatureException.getMessage(), signatureException);
            }
        }

        byte[] getSignature() throws SignatureException {
            return this.sig.sign();
        }
    }
}

