/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.DERSequence;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.CipherParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.DSA;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.Digest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.digests.NullDigest;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.util.DigestFactory;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.util.Arrays;

public class DSASigner
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected DSASigner(Digest digest, DSA dSA) {
        this.digest = digest;
        this.signer = dSA;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
        this.digest.reset();
        this.signer.init(false, asymmetricKeyParameter);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        CipherParameters cipherParameters = DSAUtil.generatePrivateKeyParameter(privateKey);
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        this.digest.reset();
        this.signer.init(true, cipherParameters);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.signer.generateSignature(byArray);
            return this.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger[] bigIntegerArray;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            bigIntegerArray = this.derDecode(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    private byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Integer[]{new ASN1Integer(bigInteger), new ASN1Integer(bigInteger2)};
        return new DERSequence(aSN1EncodableArray).getEncoded("DER");
    }

    private BigInteger[] derDecode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() != 2) {
            throw new IOException("malformed signature");
        }
        if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
            throw new IOException("malformed signature");
        }
        return new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
    }

    public static class detDSA
    extends DSASigner {
        public detDSA() {
            super(DigestFactory.createSHA1(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA1())));
        }
    }

    public static class detDSA224
    extends DSASigner {
        public detDSA224() {
            super(DigestFactory.createSHA224(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA224())));
        }
    }

    public static class detDSA256
    extends DSASigner {
        public detDSA256() {
            super(DigestFactory.createSHA256(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA256())));
        }
    }

    public static class detDSA384
    extends DSASigner {
        public detDSA384() {
            super(DigestFactory.createSHA384(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA384())));
        }
    }

    public static class detDSA512
    extends DSASigner {
        public detDSA512() {
            super(DigestFactory.createSHA512(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA512())));
        }
    }

    public static class detDSASha3_224
    extends DSASigner {
        public detDSASha3_224() {
            super(DigestFactory.createSHA3_224(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_224())));
        }
    }

    public static class detDSASha3_256
    extends DSASigner {
        public detDSASha3_256() {
            super(DigestFactory.createSHA3_256(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_256())));
        }
    }

    public static class detDSASha3_384
    extends DSASigner {
        public detDSASha3_384() {
            super(DigestFactory.createSHA3_384(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_384())));
        }
    }

    public static class detDSASha3_512
    extends DSASigner {
        public detDSASha3_512() {
            super(DigestFactory.createSHA3_512(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner(new HMacDSAKCalculator(DigestFactory.createSHA3_512())));
        }
    }

    public static class dsa224
    extends DSASigner {
        public dsa224() {
            super(DigestFactory.createSHA224(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa256
    extends DSASigner {
        public dsa256() {
            super(DigestFactory.createSHA256(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa384
    extends DSASigner {
        public dsa384() {
            super(DigestFactory.createSHA384(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsa512
    extends DSASigner {
        public dsa512() {
            super(DigestFactory.createSHA512(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_224
    extends DSASigner {
        public dsaSha3_224() {
            super(DigestFactory.createSHA3_224(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_256
    extends DSASigner {
        public dsaSha3_256() {
            super(DigestFactory.createSHA3_256(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_384
    extends DSASigner {
        public dsaSha3_384() {
            super(DigestFactory.createSHA3_384(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class dsaSha3_512
    extends DSASigner {
        public dsaSha3_512() {
            super(DigestFactory.createSHA3_512(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class noneDSA
    extends DSASigner {
        public noneDSA() {
            super(new NullDigest(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }

    public static class stdDSA
    extends DSASigner {
        public stdDSA() {
            super(DigestFactory.createSHA1(), new org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.signers.DSASigner());
        }
    }
}

