/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.prometheus.client.exporter.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.hadoop.ozone.shaded.io.prometheus.client.Collector;

public class TextFormat {
    public static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";

    public static void write004(Writer writer, Enumeration<Collector.MetricFamilySamples> mfs) throws IOException {
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = mfs.nextElement();
            writer.write("# HELP ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            TextFormat.writeEscapedHelp(writer, metricFamilySamples.help);
            writer.write(10);
            writer.write("# TYPE ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            writer.write(TextFormat.typeString(metricFamilySamples.type));
            writer.write(10);
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                writer.write(sample.name);
                if (sample.labelNames.size() > 0) {
                    writer.write(123);
                    for (int i = 0; i < sample.labelNames.size(); ++i) {
                        writer.write(sample.labelNames.get(i));
                        writer.write("=\"");
                        TextFormat.writeEscapedLabelValue(writer, sample.labelValues.get(i));
                        writer.write("\",");
                    }
                    writer.write(125);
                }
                writer.write(32);
                writer.write(Collector.doubleToGoString(sample.value));
                if (sample.timestampMs != null) {
                    writer.write(32);
                    writer.write(sample.timestampMs.toString());
                }
                writer.write(10);
            }
        }
    }

    private static void writeEscapedHelp(Writer writer, String s2) throws IOException {
        block4: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block4;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static void writeEscapedLabelValue(Writer writer, String s2) throws IOException {
        block5: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    writer.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block5;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }
}

