/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.prometheus.client;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

class CKMSQuantiles {
    private int count = 0;
    private int compressIdx = 0;
    protected LinkedList<Item> sample;
    private double[] buffer = new double[500];
    private int bufferCount = 0;
    private final Quantile[] quantiles;

    public CKMSQuantiles(Quantile[] quantiles) {
        this.quantiles = quantiles;
        this.sample = new LinkedList();
    }

    public void insert(double value) {
        this.buffer[this.bufferCount] = value;
        ++this.bufferCount;
        if (this.bufferCount == this.buffer.length) {
            this.insertBatch();
            this.compress();
        }
    }

    public double get(double q) {
        this.insertBatch();
        this.compress();
        if (this.sample.size() == 0) {
            return Double.NaN;
        }
        int rankMin = 0;
        int desired = (int)(q * (double)this.count);
        ListIterator it = this.sample.listIterator();
        Item cur = (Item)it.next();
        while (it.hasNext()) {
            Item prev = cur;
            cur = (Item)it.next();
            if (!((double)((rankMin += prev.g) + cur.g + cur.delta) > (double)desired + this.allowableError(desired) / 2.0)) continue;
            return prev.value;
        }
        return this.sample.getLast().value;
    }

    private double allowableError(int rank) {
        int size = this.sample.size();
        double minError = size + 1;
        for (Quantile q : this.quantiles) {
            double error = (double)rank <= q.quantile * (double)size ? q.u * (double)(size - rank) : q.v * (double)rank;
            if (!(error < minError)) continue;
            minError = error;
        }
        return minError;
    }

    private boolean insertBatch() {
        if (this.bufferCount == 0) {
            return false;
        }
        Arrays.sort(this.buffer, 0, this.bufferCount);
        int start = 0;
        if (this.sample.size() == 0) {
            Item newItem = new Item(this.buffer[0], 1, 0);
            this.sample.add(newItem);
            ++start;
            ++this.count;
        }
        ListIterator<Item> it = this.sample.listIterator();
        Item item = (Item)it.next();
        for (int i = start; i < this.bufferCount; ++i) {
            double v = this.buffer[i];
            while (it.nextIndex() < this.sample.size() && item.value < v) {
                item = (Item)it.next();
            }
            if (item.value > v) {
                it.previous();
            }
            int delta = it.previousIndex() == 0 || it.nextIndex() == this.sample.size() ? 0 : (int)Math.floor(this.allowableError(it.nextIndex())) - 1;
            Item newItem = new Item(v, 1, delta);
            it.add(newItem);
            ++this.count;
            item = newItem;
        }
        this.bufferCount = 0;
        return true;
    }

    private void compress() {
        if (this.sample.size() < 2) {
            return;
        }
        ListIterator it = this.sample.listIterator();
        int removed = 0;
        Item prev = null;
        Item next = (Item)it.next();
        while (it.hasNext()) {
            prev = next;
            next = (Item)it.next();
            if (!((double)(prev.g + next.g + next.delta) <= this.allowableError(it.previousIndex()))) continue;
            next.g += prev.g;
            it.previous();
            it.previous();
            it.remove();
            it.next();
            ++removed;
        }
    }

    public static class Quantile {
        public final double quantile;
        public final double error;
        public final double u;
        public final double v;

        public Quantile(double quantile, double error) {
            this.quantile = quantile;
            this.error = error;
            this.u = 2.0 * error / (1.0 - quantile);
            this.v = 2.0 * error / quantile;
        }

        public String toString() {
            return String.format("Q{q=%.3f, eps=%.3f}", this.quantile, this.error);
        }
    }

    private class Item {
        public final double value;
        public int g;
        public final int delta;

        public Item(double value, int lower_delta, int delta) {
            this.value = value;
            this.g = lower_delta;
            this.delta = delta;
        }

        public String toString() {
            return String.format("I{val=%.3f, g=%d, del=%d}", this.value, this.g, this.delta);
        }
    }
}

