/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.opentracing.util;

import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.hadoop.ozone.shaded.io.opentracing.Span;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.ThreadLocalScopeManager;

public class ThreadLocalScope
implements Scope {
    private final ThreadLocalScopeManager scopeManager;
    private final Span wrapped;
    private final boolean finishOnClose;
    private final ThreadLocalScope toRestore;

    ThreadLocalScope(ThreadLocalScopeManager scopeManager, Span wrapped, boolean finishOnClose) {
        this.scopeManager = scopeManager;
        this.wrapped = wrapped;
        this.finishOnClose = finishOnClose;
        this.toRestore = scopeManager.tlsScope.get();
        scopeManager.tlsScope.set(this);
    }

    @Override
    public void close() {
        if (this.scopeManager.tlsScope.get() != this) {
            return;
        }
        if (this.finishOnClose) {
            this.wrapped.finish();
        }
        this.scopeManager.tlsScope.set(this.toRestore);
    }

    @Override
    public Span span() {
        return this.wrapped;
    }
}

