/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.opentracing.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.ozone.shaded.io.opentracing.ScopeManager;
import org.apache.hadoop.ozone.shaded.io.opentracing.Span;
import org.apache.hadoop.ozone.shaded.io.opentracing.SpanContext;
import org.apache.hadoop.ozone.shaded.io.opentracing.Tracer;
import org.apache.hadoop.ozone.shaded.io.opentracing.noop.NoopTracer;
import org.apache.hadoop.ozone.shaded.io.opentracing.noop.NoopTracerFactory;
import org.apache.hadoop.ozone.shaded.io.opentracing.propagation.Format;

public final class GlobalTracer
implements Tracer {
    private static final Logger LOGGER = Logger.getLogger(GlobalTracer.class.getName());
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private static volatile Tracer tracer = NoopTracerFactory.create();

    private GlobalTracer() {
    }

    public static Tracer get() {
        return INSTANCE;
    }

    public static synchronized void register(Tracer tracer) {
        if (tracer == null) {
            throw new NullPointerException("Cannot register GlobalTracer <null>.");
        }
        if (tracer instanceof GlobalTracer) {
            LOGGER.log(Level.FINE, "Attempted to register the GlobalTracer as delegate of itself.");
            return;
        }
        if (GlobalTracer.isRegistered() && !GlobalTracer.tracer.equals(tracer)) {
            throw new IllegalStateException("There is already a current global Tracer registered.");
        }
        GlobalTracer.tracer = tracer;
    }

    public static synchronized boolean isRegistered() {
        return !(tracer instanceof NoopTracer);
    }

    @Override
    public ScopeManager scopeManager() {
        return tracer.scopeManager();
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return tracer.buildSpan(operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        tracer.inject(spanContext, format, carrier);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        return tracer.extract(format, carrier);
    }

    @Override
    public Span activeSpan() {
        return tracer.activeSpan();
    }

    public String toString() {
        return GlobalTracer.class.getSimpleName() + '{' + tracer + '}';
    }
}

