/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.thrift.internal.senders;

import java.util.List;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.agent.thrift.Agent;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.SenderException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thrift.internal.reporters.protocols.ThriftUdpTransport;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thrift.internal.senders.ThriftSender;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thrift.internal.senders.ThriftSenderBase;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Batch;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Process;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Span;

public class UdpSender
extends ThriftSender {
    public static final String DEFAULT_AGENT_UDP_HOST = "localhost";
    public static final int DEFAULT_AGENT_UDP_COMPACT_PORT = 6831;
    private Agent.Client agentClient;
    private ThriftUdpTransport udpTransport;

    public UdpSender() {
        this(DEFAULT_AGENT_UDP_HOST, 6831, 0);
    }

    public UdpSender(String host, int port, int maxPacketSize) {
        super(ThriftSenderBase.ProtocolType.Compact, maxPacketSize);
        if (host == null || host.length() == 0) {
            host = DEFAULT_AGENT_UDP_HOST;
        }
        if (port == 0) {
            port = 6831;
        }
        this.udpTransport = ThriftUdpTransport.newThriftUdpClient(host, port);
        this.agentClient = new Agent.Client(this.protocolFactory.getProtocol(this.udpTransport));
    }

    @Override
    public void send(Process process, List<Span> spans) throws SenderException {
        try {
            this.agentClient.emitBatch(new Batch(process, spans));
        }
        catch (Exception e) {
            throw new SenderException(String.format("Could not send %d spans", spans.size()), e, spans.size());
        }
    }

    @Override
    public int close() throws SenderException {
        try {
            int n = super.close();
            return n;
        }
        finally {
            this.udpTransport.close();
        }
    }

    @Override
    public String toString() {
        return "UdpSender()";
    }
}

