/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.thrift.internal.reporters.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpan;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.LogData;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.Reference;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Log;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Span;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.SpanRef;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.SpanRefType;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.Tag;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.thriftjava.TagType;

public class JaegerThriftSpanConverter {
    private JaegerThriftSpanConverter() {
    }

    public static Span convertSpan(JaegerSpan jaegerSpan) {
        JaegerSpanContext context = jaegerSpan.context();
        boolean oneChildOfParent = jaegerSpan.getReferences().size() == 1 && "child_of".equals(jaegerSpan.getReferences().get(0).getType());
        List<SpanRef> references = oneChildOfParent ? Collections.emptyList() : JaegerThriftSpanConverter.buildReferences(jaegerSpan.getReferences());
        return new Span(context.getTraceIdLow(), context.getTraceIdHigh(), context.getSpanId(), oneChildOfParent ? context.getParentId() : 0L, jaegerSpan.getOperationName(), context.getFlags(), jaegerSpan.getStart(), jaegerSpan.getDuration()).setReferences(references).setTags(JaegerThriftSpanConverter.buildTags(jaegerSpan.getTags())).setLogs(JaegerThriftSpanConverter.buildLogs(jaegerSpan.getLogs()));
    }

    static List<SpanRef> buildReferences(List<Reference> references) {
        ArrayList<SpanRef> thriftReferences = new ArrayList<SpanRef>(references.size());
        for (Reference reference : references) {
            SpanRefType thriftRefType = "child_of".equals(reference.getType()) ? SpanRefType.CHILD_OF : SpanRefType.FOLLOWS_FROM;
            thriftReferences.add(new SpanRef(thriftRefType, reference.getSpanContext().getTraceIdLow(), reference.getSpanContext().getTraceIdHigh(), reference.getSpanContext().getSpanId()));
        }
        return thriftReferences;
    }

    static List<Log> buildLogs(List<LogData> logs) {
        ArrayList<Log> thriftLogs = new ArrayList<Log>();
        if (logs != null) {
            for (LogData logData : logs) {
                Log thriftLog = new Log();
                thriftLog.setTimestamp(logData.getTime());
                if (logData.getFields() != null) {
                    thriftLog.setFields(JaegerThriftSpanConverter.buildTags(logData.getFields()));
                } else {
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    if (logData.getMessage() != null) {
                        tags.add(JaegerThriftSpanConverter.buildTag("event", logData.getMessage()));
                    }
                    thriftLog.setFields(tags);
                }
                thriftLogs.add(thriftLog);
            }
        }
        return thriftLogs;
    }

    public static List<Tag> buildTags(Map<String, ?> tags) {
        ArrayList<Tag> thriftTags = new ArrayList<Tag>();
        if (tags != null) {
            for (Map.Entry<String, ?> entry : tags.entrySet()) {
                String tagKey = entry.getKey();
                Object tagValue = entry.getValue();
                thriftTags.add(JaegerThriftSpanConverter.buildTag(tagKey, tagValue));
            }
        }
        return thriftTags;
    }

    static Tag buildTag(String tagKey, Object tagValue) {
        Tag tag = new Tag();
        tag.setKey(tagKey);
        if (tagValue instanceof Integer || tagValue instanceof Short || tagValue instanceof Long) {
            tag.setVType(TagType.LONG);
            tag.setVLong(((Number)tagValue).longValue());
        } else if (tagValue instanceof Double || tagValue instanceof Float) {
            tag.setVType(TagType.DOUBLE);
            tag.setVDouble(((Number)tagValue).doubleValue());
        } else if (tagValue instanceof Boolean) {
            tag.setVType(TagType.BOOL);
            tag.setVBool((Boolean)tagValue);
        } else {
            JaegerThriftSpanConverter.buildStringTag(tag, tagValue);
        }
        return tag;
    }

    static void buildStringTag(Tag tag, Object tagValue) {
        tag.setVType(TagType.STRING);
        tag.setVStr(String.valueOf(tagValue));
    }
}

