/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.EmptyIpException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.NotFourOctetsException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.utils.Java6CompatibleThreadLocalRandom;

public class Utils {
    public static String normalizeBaggageKey(String key) {
        return key.replaceAll("_", "-").toLowerCase(Locale.ROOT);
    }

    public static int ipToInt(String ip) throws EmptyIpException, NotFourOctetsException {
        InetAddress octets;
        if (ip.equals("")) {
            throw new EmptyIpException();
        }
        if (ip.equals("localhost")) {
            return 2130706433;
        }
        try {
            octets = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            throw new NotFourOctetsException();
        }
        int intIp = 0;
        for (byte octet : octets.getAddress()) {
            intIp = intIp << 8 | octet & 0xFF;
        }
        return intIp;
    }

    public static long uniqueId() {
        long val = 0L;
        while (val == 0L) {
            val = Java6CompatibleThreadLocalRandom.current().nextLong();
        }
        return val;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private Utils() {
    }
}

