/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.senders;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.Configuration;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.senders.NoopSender;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.Sender;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.SenderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderResolver {
    private static final Logger log = LoggerFactory.getLogger(SenderResolver.class);

    public static Sender resolve() {
        return SenderResolver.resolve(Configuration.SenderConfiguration.fromEnv());
    }

    public static Sender resolve(Configuration.SenderConfiguration senderConfiguration) {
        Sender sender = null;
        ServiceLoader<SenderFactory> senderFactoryServiceLoader = ServiceLoader.load(SenderFactory.class, SenderFactory.class.getClassLoader());
        Iterator<SenderFactory> senderFactoryIterator = senderFactoryServiceLoader.iterator();
        boolean hasMultipleFactories = false;
        while (senderFactoryIterator.hasNext()) {
            SenderFactory senderFactory = senderFactoryIterator.next();
            if (senderFactoryIterator.hasNext()) {
                log.debug("There are multiple factories available via the service loader.");
                hasMultipleFactories = true;
            }
            if (hasMultipleFactories) {
                String requestedFactory = System.getProperty("JAEGER_SENDER_FACTORY");
                if (!senderFactory.getType().equals(requestedFactory)) continue;
                log.debug(String.format("Found the requested (%s) sender factory: %s", requestedFactory, senderFactory));
                sender = SenderResolver.getSenderFromFactory(senderFactory, senderConfiguration);
                continue;
            }
            sender = SenderResolver.getSenderFromFactory(senderFactory, senderConfiguration);
        }
        if (null != sender) {
            log.debug(String.format("Using sender %s", sender));
            return sender;
        }
        log.warn("No suitable sender found. Using NoopSender, meaning that data will not be sent anywhere!");
        return new NoopSender();
    }

    private static Sender getSenderFromFactory(SenderFactory senderFactory, Configuration.SenderConfiguration configuration) {
        try {
            return senderFactory.getSender(configuration);
        }
        catch (Exception e) {
            log.warn("Failed to get a sender from the sender factory.", (Throwable)e);
            return null;
        }
    }
}

