/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.propagation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HexCodec {
    private static final Logger log = LoggerFactory.getLogger(HexCodec.class);
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static Long lowerHexToUnsignedLong(String lowerHex) {
        int length = lowerHex.length();
        if (length < 1 || length > 32) {
            log.debug("token {} size is out of bounds [1, 32]", (Object)lowerHex);
            return null;
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return HexCodec.hexToUnsignedLong(lowerHex, beginIndex, Math.min(beginIndex + 16, lowerHex.length()));
    }

    static Long higherHexToUnsignedLong(String higherHex) {
        int length = higherHex.length();
        if (length > 32 || length < 1) {
            log.debug("token {} size is out of bounds [1, 32]", (Object)higherHex);
            return null;
        }
        return HexCodec.hexToUnsignedLong(higherHex, 0, Math.max(length - 16, 0));
    }

    static Long hexToUnsignedLong(String lowerHex, int index, int endIndex) {
        long result = 0L;
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
            } else {
                return null;
            }
            ++index;
        }
        return result;
    }

    static String toLowerHex(long high, long low) {
        char[] result = new char[high != 0L ? 32 : 16];
        int pos = 0;
        if (high != 0L) {
            HexCodec.writeHexLong(result, pos, high);
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, low);
        return new String(result);
    }

    static String toLowerHex(long v) {
        char[] data = new char[16];
        HexCodec.writeHexLong(data, 0, v);
        return new String(data);
    }

    static void writeHexLong(char[] data, int pos, long v) {
        HexCodec.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        HexCodec.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    HexCodec() {
    }
}

