/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.baggage;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ozone.shaded.com.google.gson.Gson;
import org.apache.hadoop.ozone.shaded.com.google.gson.JsonSyntaxException;
import org.apache.hadoop.ozone.shaded.com.google.gson.reflect.TypeToken;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.baggage.http.BaggageRestrictionResponse;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.BaggageRestrictionManagerException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.utils.Http;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.spi.BaggageRestrictionManagerProxy;

public class HttpBaggageRestrictionManagerProxy
implements BaggageRestrictionManagerProxy {
    private static final String DEFAULT_HOST_PORT = "localhost:5778";
    private static final Type LIST_TYPE = new TypeToken<ArrayList<BaggageRestrictionResponse>>(){}.getType();
    private final Gson gson = new Gson();
    private final String hostPort;

    public HttpBaggageRestrictionManagerProxy(String hostPort) {
        this.hostPort = hostPort != null ? hostPort : DEFAULT_HOST_PORT;
    }

    List<BaggageRestrictionResponse> parseJson(String json) throws BaggageRestrictionManagerException {
        try {
            return (List)this.gson.fromJson(json, LIST_TYPE);
        }
        catch (JsonSyntaxException e) {
            throw new BaggageRestrictionManagerException("Cannot deserialize json", e);
        }
    }

    @Override
    public List<BaggageRestrictionResponse> getBaggageRestrictions(String serviceName) throws BaggageRestrictionManagerException {
        String jsonString;
        try {
            jsonString = Http.makeGetRequest("http://" + this.hostPort + "/baggageRestrictions?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new BaggageRestrictionManagerException("http call to get baggage restriction from local agent failed.", e);
        }
        return this.parseJson(jsonString);
    }
}

