/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.com.lmax.disruptor;

import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.AlertException;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.Sequence;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.SequenceBarrier;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.WaitStrategy;

public final class YieldingWaitStrategy
implements WaitStrategy {
    private static final int SPIN_TRIES = 100;

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        int counter = 100;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            counter = this.applyWaitMethod(barrier, counter);
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(SequenceBarrier barrier, int counter) throws AlertException {
        barrier.checkAlert();
        if (0 == counter) {
            Thread.yield();
        } else {
            --counter;
        }
        return counter;
    }
}

