/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shaded.com.lmax.disruptor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.AlertException;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.Sequence;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.SequenceBarrier;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.WaitStrategy;
import org.apache.hadoop.ozone.shaded.com.lmax.disruptor.util.ThreadHints;

public final class LiteBlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence) {
            this.lock.lock();
            try {
                do {
                    this.signalNeeded.getAndSet(true);
                    if (cursorSequence.get() >= sequence) {
                        break;
                    }
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                } while (cursorSequence.get() < sequence);
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            ThreadHints.onSpinWait();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            this.lock.lock();
            try {
                this.processorNotifyCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String toString() {
        return "LiteBlockingWaitStrategy{processorNotifyCondition=" + this.processorNotifyCondition + '}';
    }
}

