/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public abstract class OzoneObj
implements IOzoneObj {
    private final ResourceType resType;
    private final StoreType storeType;

    OzoneObj(ResourceType resType, StoreType storeType) {
        Preconditions.checkNotNull(resType);
        Preconditions.checkNotNull(storeType);
        this.resType = resType;
        this.storeType = storeType;
    }

    public static OzoneManagerProtocolProtos.OzoneObj toProtobuf(OzoneObj obj) {
        return OzoneManagerProtocolProtos.OzoneObj.newBuilder().setResType(OzoneManagerProtocolProtos.OzoneObj.ObjectType.valueOf(obj.getResourceType().name())).setStoreType(OzoneManagerProtocolProtos.OzoneObj.StoreType.valueOf(obj.getStoreType().name())).setPath(obj.getPath()).build();
    }

    public ResourceType getResourceType() {
        return this.resType;
    }

    public String toString() {
        return "OzoneObj{resType=" + (Object)((Object)this.resType) + ", storeType=" + (Object)((Object)this.storeType) + ", path='" + this.getPath() + '\'' + '}';
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public abstract String getVolumeName();

    public abstract String getBucketName();

    public abstract String getKeyName();

    public abstract String getPrefixName();

    public abstract String getPath();

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("resourceType", this.getResourceType().value);
        auditMap.put("storageType", this.getStoreType().value);
        auditMap.put("volume", this.getVolumeName());
        auditMap.put("bucket", this.getBucketName());
        auditMap.put("key", this.getKeyName());
        return auditMap;
    }

    public static enum StoreType {
        OZONE("ozone"),
        S3("s3");

        private final String value;

        public String toString() {
            return this.value;
        }

        private StoreType(String objType) {
            this.value = objType;
        }
    }

    public static enum ResourceType {
        VOLUME("volume"),
        BUCKET("bucket"),
        KEY("key"),
        PREFIX("prefix");

        private final String value;

        public String toString() {
            return this.value;
        }

        private ResourceType(String resType) {
            this.value = resType;
        }
    }
}

