/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneSecretStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneSecretStore.class);
    private OMMetadataManager omMetadataManager;

    @Override
    public void close() throws IOException {
        if (this.omMetadataManager != null) {
            try {
                this.omMetadataManager.getDelegationTokenTable().close();
            }
            catch (Exception e) {
                throw new IOException("Error while closing OzoneSecretStore.", e);
            }
        }
    }

    public OzoneSecretStore(OzoneConfiguration conf, OMMetadataManager omMetadataManager) {
        this.omMetadataManager = omMetadataManager;
    }

    public OzoneManagerSecretState loadState() throws IOException {
        OzoneManagerSecretState state = new OzoneManagerSecretState();
        int numTokens = this.loadTokens(state);
        LOG.info("Loaded {} tokens", (Object)numTokens);
        return state;
    }

    public void storeToken(OzoneTokenIdentifier tokenId, long renewDate) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing token {}", (Object)tokenId.getSequenceNumber());
        }
        try {
            this.omMetadataManager.getDelegationTokenTable().put(tokenId, renewDate);
        }
        catch (IOException e) {
            LOG.error("Unable to store token " + tokenId.toString(), (Throwable)e);
            throw e;
        }
    }

    public void updateToken(OzoneTokenIdentifier tokenId, long renewDate) throws IOException {
        this.storeToken(tokenId, renewDate);
    }

    public void removeToken(OzoneTokenIdentifier tokenId) throws IOException {
        try {
            this.omMetadataManager.getDelegationTokenTable().delete(tokenId);
        }
        catch (IOException e) {
            LOG.error("Unable to remove token {}", (Object)tokenId.toString(), (Object)e);
            throw e;
        }
    }

    public int loadTokens(OzoneManagerSecretState state) throws IOException {
        int loadedToken = 0;
        try (TableIterator<OzoneTokenIdentifier, Table.KeyValue<OzoneTokenIdentifier, Long>> iterator = this.omMetadataManager.getDelegationTokenTable().iterator();){
            iterator.seekToFirst();
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                state.tokenState.put(kv.getKey(), kv.getValue());
                ++loadedToken;
            }
        }
        return loadedToken;
    }

    public static class OzoneManagerSecretState<T> {
        private Map<T, Long> tokenState = new HashMap<T, Long>();

        public Map<T, Long> getTokenState() {
            return this.tokenState;
        }
    }
}

