/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.keys.SecurityUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneSecretKey
implements Writable {
    private int keyId;
    private long expiryDate;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private SecurityConfig securityConfig;

    public OzoneSecretKey(int keyId, long expiryDate, KeyPair keyPair) {
        Preconditions.checkNotNull(keyId);
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public OzoneSecretKey(int keyId, long expiryDate, byte[] pvtKey, byte[] publicKey) {
        Preconditions.checkNotNull(pvtKey);
        Preconditions.checkNotNull(publicKey);
        this.securityConfig = new SecurityConfig(new OzoneConfiguration());
        this.keyId = keyId;
        this.expiryDate = expiryDate;
        this.privateKey = SecurityUtil.getPrivateKey(pvtKey, this.securityConfig);
        this.publicKey = SecurityUtil.getPublicKey(publicKey, this.securityConfig);
    }

    public int getKeyId() {
        return this.keyId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public byte[] getEncodedPubliceKey() {
        return this.publicKey.getEncoded();
    }

    public void setExpiryDate(long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void write(DataOutput out) throws IOException {
        OzoneManagerProtocolProtos.SecretKeyProto token = OzoneManagerProtocolProtos.SecretKeyProto.newBuilder().setKeyId(this.getKeyId()).setExpiryDate(this.getExpiryDate()).setPrivateKeyBytes(ByteString.copyFrom(this.getEncodedPrivateKey())).setPublicKeyBytes(ByteString.copyFrom(this.getEncodedPubliceKey())).build();
        out.write(token.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        OzoneManagerProtocolProtos.SecretKeyProto secretKey = OzoneManagerProtocolProtos.SecretKeyProto.parseFrom((DataInputStream)in);
        this.expiryDate = secretKey.getExpiryDate();
        this.keyId = secretKey.getKeyId();
        this.privateKey = SecurityUtil.getPrivateKey(secretKey.getPrivateKeyBytes().toByteArray(), this.securityConfig);
        this.publicKey = SecurityUtil.getPublicKey(secretKey.getPublicKeyBytes().toByteArray(), this.securityConfig);
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(537, 963);
        hashCodeBuilder.append(this.getExpiryDate()).append(this.getKeyId()).append(this.getEncodedPrivateKey()).append(this.getEncodedPubliceKey());
        return hashCodeBuilder.build();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OzoneSecretKey) {
            OzoneSecretKey that = (OzoneSecretKey)obj;
            return new EqualsBuilder().append(this.keyId, that.keyId).append(this.expiryDate, that.expiryDate).append((Object)this.privateKey, (Object)that.privateKey).append((Object)this.publicKey, (Object)that.publicKey).build();
        }
        return false;
    }

    static OzoneSecretKey readProtoBuf(DataInput in) throws IOException {
        Preconditions.checkNotNull(in);
        OzoneManagerProtocolProtos.SecretKeyProto key = OzoneManagerProtocolProtos.SecretKeyProto.parseFrom((DataInputStream)in);
        return new OzoneSecretKey(key.getKeyId(), key.getExpiryDate(), key.getPrivateKeyBytes().toByteArray(), key.getPublicKeyBytes().toByteArray());
    }

    static OzoneSecretKey readProtoBuf(byte[] identifier) throws IOException {
        Preconditions.checkNotNull(identifier);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(identifier));
        return OzoneSecretKey.readProtoBuf(in);
    }
}

