/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class GDPRSymmetricKey {
    private SecretKeySpec secretKey;
    private Cipher cipher;
    private String algorithm;
    private String secret;

    public SecretKeySpec getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public GDPRSymmetricKey(SecureRandom secureRandom) throws Exception {
        this.algorithm = "AES";
        this.secret = RandomStringUtils.random((int)16, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)secureRandom);
        this.secretKey = new SecretKeySpec(this.secret.getBytes("UTF-8"), this.algorithm);
        this.cipher = Cipher.getInstance(this.algorithm);
    }

    public GDPRSymmetricKey(String secret, String algorithm) throws Exception {
        Preconditions.checkNotNull(secret, "Secret cannot be null");
        Preconditions.checkArgument(secret.length() == 16, "Secret must be exactly 16 characters");
        Preconditions.checkNotNull(algorithm, "Algorithm cannot be null");
        this.secret = secret;
        this.algorithm = algorithm;
        this.secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), algorithm);
        this.cipher = Cipher.getInstance(algorithm);
    }

    public Map<String, String> getKeyDetails() {
        HashMap<String, String> keyDetail = new HashMap<String, String>();
        keyDetail.put("secret", this.secret);
        keyDetail.put("algorithm", this.algorithm);
        return keyDetail;
    }
}

