/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;

public class RegisteredCommand {
    private String clusterID;
    private StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error;
    private DatanodeDetails datanode;

    public RegisteredCommand(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error, DatanodeDetails node, String clusterID) {
        this.datanode = node;
        this.clusterID = clusterID;
        this.error = error;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public DatanodeDetails getDatanode() {
        return this.datanode;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode getError() {
        return this.error;
    }

    public StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto getProtoBufMessage() {
        StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.Builder builder = StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.newBuilder().setClusterID(this.clusterID).setDatanodeUUID(this.datanode.getUuidString()).setErrorCode(this.error);
        if (!Strings.isNullOrEmpty(this.datanode.getHostName())) {
            builder.setHostname(this.datanode.getHostName());
        }
        if (!Strings.isNullOrEmpty(this.datanode.getIpAddress())) {
            builder.setIpAddress(this.datanode.getIpAddress());
        }
        if (!Strings.isNullOrEmpty(this.datanode.getNetworkName())) {
            builder.setNetworkName(this.datanode.getNetworkName());
        }
        if (!Strings.isNullOrEmpty(this.datanode.getNetworkLocation())) {
            builder.setNetworkLocation(this.datanode.getNetworkLocation());
        }
        return builder.build();
    }

    public static class Builder {
        private DatanodeDetails datanode;
        private String clusterID;
        private StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error;

        public Builder setDatanode(DatanodeDetails node) {
            this.datanode = node;
            return this;
        }

        public Builder setClusterID(String cluster) {
            this.clusterID = cluster;
            return this;
        }

        public Builder setErrorCode(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode errorCode) {
            this.error = errorCode;
            return this;
        }

        public RegisteredCommand build() {
            if (this.error == StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.success && (this.datanode == null || Strings.isNullOrEmpty(this.datanode.getUuidString()) || Strings.isNullOrEmpty(this.clusterID))) {
                throw new IllegalArgumentException("On success, RegisteredCommand needs datanodeUUID and ClusterID.");
            }
            return new RegisteredCommand(this.error, this.datanode, this.clusterID);
        }
    }
}

