/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class DeleteContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto> {
    private final long containerId;
    private final boolean force;

    public DeleteContainerCommand(long containerId) {
        this(containerId, false);
    }

    public DeleteContainerCommand(long containerId, boolean forceFlag) {
        this.containerId = containerId;
        this.force = forceFlag;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto.newBuilder();
        builder.setCmdId(this.getId()).setContainerID(this.getContainerID()).setForce(this.force);
        return builder.build();
    }

    public long getContainerID() {
        return this.containerId;
    }

    public boolean isForce() {
        return this.force;
    }

    public static DeleteContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto protoMessage) {
        Preconditions.checkNotNull(protoMessage);
        return new DeleteContainerCommand(protoMessage.getContainerID(), protoMessage.getForce());
    }
}

