/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class CreatePipelineCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto> {
    private final PipelineID pipelineID;
    private final HddsProtos.ReplicationFactor factor;
    private final HddsProtos.ReplicationType type;
    private final List<DatanodeDetails> nodelist;

    public CreatePipelineCommand(PipelineID pipelineID, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> datanodeList) {
        this.pipelineID = pipelineID;
        this.factor = factor;
        this.type = type;
        this.nodelist = datanodeList;
    }

    public CreatePipelineCommand(long cmdId, PipelineID pipelineID, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> datanodeList) {
        super(cmdId);
        this.pipelineID = pipelineID;
        this.factor = factor;
        this.type = type;
        this.nodelist = datanodeList;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.createPipelineCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto getProto() {
        return StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto.newBuilder().setCmdId(this.getId()).setPipelineID(this.pipelineID.getProtobuf()).setFactor(this.factor).setType(this.type).addAllDatanode(this.nodelist.stream().map(DatanodeDetails::getProtoBufMessage).collect(Collectors.toList())).build();
    }

    public static CreatePipelineCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.CreatePipelineCommandProto createPipelineProto) {
        Preconditions.checkNotNull(createPipelineProto);
        return new CreatePipelineCommand(createPipelineProto.getCmdId(), PipelineID.getFromProtobuf(createPipelineProto.getPipelineID()), createPipelineProto.getType(), createPipelineProto.getFactor(), createPipelineProto.getDatanodeList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList()));
    }

    public PipelineID getPipelineID() {
        return this.pipelineID;
    }
}

