/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.db.DBUpdatesWrapper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class OzoneManagerProtocolClientSideTranslatorPB
implements OzoneManagerProtocol,
ProtocolTranslator {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final OMFailoverProxyProvider omFailoverProxyProvider;
    private final OzoneManagerProtocolPB rpcProxy;
    private final String clientID;
    private static final Logger FAILOVER_PROXY_PROVIDER_LOG = LoggerFactory.getLogger(OMFailoverProxyProvider.class);

    public OzoneManagerProtocolClientSideTranslatorPB(OzoneManagerProtocolPB proxy, String clientId) {
        this.rpcProxy = proxy;
        this.clientID = clientId;
        this.omFailoverProxyProvider = null;
    }

    public OzoneManagerProtocolClientSideTranslatorPB(OzoneConfiguration conf, String clientId, String omServiceId, UserGroupInformation ugi) throws IOException {
        this.omFailoverProxyProvider = new OMFailoverProxyProvider(conf, ugi, omServiceId);
        int maxFailovers = conf.getInt("ozone.client.failover.max.attempts", 15);
        int sleepBase = conf.getInt("ozone.client.failover.sleep.base.millis", 500);
        int sleepMax = conf.getInt("ozone.client.failover.sleep.max.millis", 15000);
        this.rpcProxy = this.createRetryProxy(this.omFailoverProxyProvider, maxFailovers, sleepBase, sleepMax);
        this.clientID = clientId;
    }

    private OzoneManagerProtocolPB createRetryProxy(OMFailoverProxyProvider failoverProxyProvider, final int maxFailovers, int delayMillis, int maxDelayBase) {
        RetryPolicy retryPolicy = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                if (OzoneManagerProtocolClientSideTranslatorPB.this.isAccessControlException(exception)) {
                    return RetryPolicy.RetryAction.FAIL;
                }
                if (exception instanceof ServiceException) {
                    OMNotLeaderException notLeaderException = OzoneManagerProtocolClientSideTranslatorPB.this.getNotLeaderException(exception);
                    if (notLeaderException != null && notLeaderException.getSuggestedLeaderNodeId() != null) {
                        OzoneManagerProtocolClientSideTranslatorPB.this.omFailoverProxyProvider.performFailoverIfRequired(notLeaderException.getSuggestedLeaderNodeId());
                        return this.getRetryAction(RetryPolicy.RetryAction.FAILOVER_AND_RETRY, failovers);
                    }
                    OMLeaderNotReadyException leaderNotReadyException = OzoneManagerProtocolClientSideTranslatorPB.this.getLeaderNotReadyException(exception);
                    if (leaderNotReadyException != null) {
                        return this.getRetryAction(RetryPolicy.RetryAction.FAILOVER_AND_RETRY, failovers);
                    }
                }
                OzoneManagerProtocolClientSideTranslatorPB.this.omFailoverProxyProvider.performFailoverToNextProxy();
                return this.getRetryAction(RetryPolicy.RetryAction.FAILOVER_AND_RETRY, failovers);
            }

            private RetryPolicy.RetryAction getRetryAction(RetryPolicy.RetryAction fallbackAction, int failovers) {
                if (failovers <= maxFailovers) {
                    return fallbackAction;
                }
                FAILOVER_PROXY_PROVIDER_LOG.error("Failed to connect to OMs: {}. Attempted {} failovers.", OzoneManagerProtocolClientSideTranslatorPB.this.omFailoverProxyProvider.getOMProxyInfos(), (Object)maxFailovers);
                return RetryPolicy.RetryAction.FAIL;
            }
        };
        OzoneManagerProtocolPB proxy = (OzoneManagerProtocolPB)RetryProxy.create(OzoneManagerProtocolPB.class, (FailoverProxyProvider)failoverProxyProvider, (RetryPolicy)retryPolicy);
        return proxy;
    }

    private boolean isAccessControlException(Exception ex) {
        if (ex instanceof ServiceException) {
            for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                if (!(t instanceof AccessControlException)) continue;
                return true;
            }
        }
        return false;
    }

    private OMNotLeaderException getNotLeaderException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMNotLeaderException) {
            return (OMNotLeaderException)ioException;
        }
        return null;
    }

    private OMLeaderNotReadyException getLeaderNotReadyException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMLeaderNotReadyException) {
            return (OMLeaderNotReadyException)ioException;
        }
        return null;
    }

    @Override
    @VisibleForTesting
    public OMFailoverProxyProvider getOMFailoverProxyProvider() {
        return this.omFailoverProxyProvider;
    }

    @Override
    public void close() throws IOException {
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    private OzoneManagerProtocolProtos.OMRequest.Builder createOMRequest(OzoneManagerProtocolProtos.Type cmdType) {
        return OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(cmdType).setClientId(this.clientID);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws IOException {
        try {
            OzoneManagerProtocolProtos.OMRequest payload = OzoneManagerProtocolProtos.OMRequest.newBuilder(omRequest).setTraceID(TracingUtil.exportCurrentSpan()).build();
            OzoneManagerProtocolProtos.OMResponse omResponse = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, payload);
            if (omResponse.hasLeaderOMNodeId() && this.omFailoverProxyProvider != null) {
                String leaderOmId = omResponse.getLeaderOMNodeId();
                this.omFailoverProxyProvider.performFailoverIfRequired(leaderOmId);
            }
            return omResponse;
        }
        catch (ServiceException e) {
            OMNotLeaderException notLeaderException = this.getNotLeaderException(e);
            if (notLeaderException == null) {
                throw ProtobufHelper.getRemoteException((ServiceException)e);
            }
            throw new IOException("Could not determine or connect to OM Leader.");
        }
    }

    @Override
    public void createVolume(OmVolumeArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateVolumeRequest.Builder req = OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder();
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = args.getProtobuf();
        req.setVolumeInfo(volumeInfo);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateVolume).setCreateVolumeRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public void setOwner(String volume, String owner) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setOwnerName(owner);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public void setQuota(String volume, long quota) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest.Builder req = OzoneManagerProtocolProtos.SetVolumePropertyRequest.newBuilder();
        req.setVolumeName(volume).setQuotaInBytes(quota);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setSetVolumePropertyRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        this.handleError(omResponse);
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessRequest.Builder req = OzoneManagerProtocolProtos.CheckVolumeAccessRequest.newBuilder();
        req.setVolumeName(volume).setUserAcl(userAcl);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CheckVolumeAccess).setCheckVolumeAccessRequest(req).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.ACCESS_DENIED) {
            return false;
        }
        if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            return true;
        }
        this.handleError(omResponse);
        return false;
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeRequest.Builder req = OzoneManagerProtocolProtos.InfoVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoVolume).setInfoVolumeRequest(req).build();
        OzoneManagerProtocolProtos.InfoVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoVolumeResponse();
        return OmVolumeArgs.getFromProtobuf(resp.getVolumeInfo());
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        OzoneManagerProtocolProtos.DeleteVolumeRequest.Builder req = OzoneManagerProtocolProtos.DeleteVolumeRequest.newBuilder();
        req.setVolumeName(volume);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteVolume).setDeleteVolumeRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty(prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty(prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setUserName(userName);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER);
        return this.listVolume(builder.build());
    }

    @Override
    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeRequest.Builder builder = OzoneManagerProtocolProtos.ListVolumeRequest.newBuilder();
        if (!Strings.isNullOrEmpty(prefix)) {
            builder.setPrefix(prefix);
        }
        if (!Strings.isNullOrEmpty(prevKey)) {
            builder.setPrevKey(prevKey);
        }
        builder.setMaxKeys(maxKeys);
        builder.setScope(OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER);
        return this.listVolume(builder.build());
    }

    private List<OmVolumeArgs> listVolume(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListVolume).setListVolumeRequest(request).build();
        OzoneManagerProtocolProtos.ListVolumeResponse resp = this.handleError(this.submitRequest(omRequest)).getListVolumeResponse();
        ArrayList<OmVolumeArgs> list = new ArrayList<OmVolumeArgs>(resp.getVolumeInfoList().size());
        for (OzoneManagerProtocolProtos.VolumeInfo info : resp.getVolumeInfoList()) {
            list.add(OmVolumeArgs.getFromProtobuf(info));
        }
        return list;
    }

    @Override
    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder req = OzoneManagerProtocolProtos.CreateBucketRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketInfo bucketInfoProtobuf = bucketInfo.getProtobuf();
        req.setBucketInfo(bucketInfoProtobuf);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateBucket).setCreateBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketRequest.Builder req = OzoneManagerProtocolProtos.InfoBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoBucket).setInfoBucketRequest(req).build();
        OzoneManagerProtocolProtos.InfoBucketResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoBucketResponse();
        return OmBucketInfo.getFromProtobuf(resp.getBucketInfo());
    }

    @Override
    public void setBucketProperty(OmBucketArgs args) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest.Builder req = OzoneManagerProtocolProtos.SetBucketPropertyRequest.newBuilder();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = args.getProtobuf();
        req.setBucketArgs(bucketArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetBucketProperty).setSetBucketPropertyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int count) throws IOException {
        ArrayList<OmBucketInfo> buckets = new ArrayList<OmBucketInfo>();
        OzoneManagerProtocolProtos.ListBucketsRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListBucketsRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setCount(count);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListBucketsRequest request = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListBuckets).setListBucketsRequest(request).build();
        OzoneManagerProtocolProtos.ListBucketsResponse resp = this.handleError(this.submitRequest(omRequest)).getListBucketsResponse();
        buckets.addAll(resp.getBucketInfoList().stream().map(OmBucketInfo::getFromProtobuf).collect(Collectors.toList()));
        return buckets;
    }

    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder req = OzoneManagerProtocolProtos.CreateKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName());
        if (args.getAcls() != null) {
            keyArgs.addAllAcls(args.getAcls().stream().distinct().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList()));
        }
        if (args.getFactor() != null) {
            keyArgs.setFactor(args.getFactor());
        }
        if (args.getType() != null) {
            keyArgs.setType(args.getType());
        }
        if (args.getDataSize() > 0L) {
            keyArgs.setDataSize(args.getDataSize());
        }
        if (args.getMetadata() != null && args.getMetadata().size() > 0) {
            keyArgs.addAllMetadata(KeyValueUtil.toProtobuf(args.getMetadata()));
        }
        req.setKeyArgs(keyArgs.build());
        if (args.getMultipartUploadID() != null) {
            keyArgs.setMultipartUploadID(args.getMultipartUploadID());
        }
        if (args.getMultipartUploadPartNumber() > 0) {
            keyArgs.setMultipartNumber(args.getMultipartUploadPartNumber());
        }
        keyArgs.setIsMultipartKey(args.getIsMultipartKey());
        req.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateKey).setCreateKeyRequest(req).build();
        OzoneManagerProtocolProtos.CreateKeyResponse keyResponse = this.handleError(this.submitRequest(omRequest)).getCreateKeyResponse();
        return new OpenKeySession(keyResponse.getID(), OmKeyInfo.getFromProtobuf(keyResponse.getKeyInfo()), keyResponse.getOpenVersion());
    }

    private OzoneManagerProtocolProtos.OMResponse handleError(OzoneManagerProtocolProtos.OMResponse resp) throws OMException {
        if (resp.getStatus() != OzoneManagerProtocolProtos.Status.OK) {
            throw new OMException(resp.getMessage(), OMException.ResultCodes.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientId, ExcludeList excludeList) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder req = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize());
        if (args.getFactor() != null) {
            keyArgs.setFactor(args.getFactor());
        }
        if (args.getType() != null) {
            keyArgs.setType(args.getType());
        }
        req.setKeyArgs(keyArgs);
        req.setClientID(clientId);
        req.setExcludeList(excludeList.getProtoBuf());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AllocateBlock).setAllocateBlockRequest(req).build();
        OzoneManagerProtocolProtos.AllocateBlockResponse resp = this.handleError(this.submitRequest(omRequest)).getAllocateBlockResponse();
        return OmKeyLocationInfo.getFromProtobuf(resp.getKeyLocation());
    }

    @Override
    public void commitKey(OmKeyArgs args, long clientId) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyRequest.Builder req = OzoneManagerProtocolProtos.CommitKeyRequest.newBuilder();
        List<OmKeyLocationInfo> locationInfoList = args.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).addAllKeyLocations(locationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList())).build();
        req.setKeyArgs(keyArgs);
        req.setClientID(clientId);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitKey).setCommitKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyRequest.Builder req = OzoneManagerProtocolProtos.LookupKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setSortDatanodes(args.getSortDatanodes()).build();
        req.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupKey).setLookupKeyRequest(req).build();
        OzoneManagerProtocolProtos.LookupKeyResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupKeyResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyRequest.Builder req = OzoneManagerProtocolProtos.RenameKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).build();
        req.setKeyArgs(keyArgs);
        req.setToKeyName(toKeyName);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKey).setRenameKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyRequest.Builder req = OzoneManagerProtocolProtos.DeleteKeyRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        req.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKey).setDeleteKeyRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteBucket(String volume, String bucket) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketRequest.Builder req = OzoneManagerProtocolProtos.DeleteBucketRequest.newBuilder();
        req.setVolumeName(volume);
        req.setBucketName(bucket);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteBucket).setDeleteBucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String prefix, int maxKeys) throws IOException {
        ArrayList<OmKeyInfo> keys = new ArrayList<OmKeyInfo>();
        OzoneManagerProtocolProtos.ListKeysRequest.Builder reqBuilder = OzoneManagerProtocolProtos.ListKeysRequest.newBuilder();
        reqBuilder.setVolumeName(volumeName);
        reqBuilder.setBucketName(bucketName);
        reqBuilder.setCount(maxKeys);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.ListKeysRequest req = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListKeys).setListKeysRequest(req).build();
        OzoneManagerProtocolProtos.ListKeysResponse resp = this.handleError(this.submitRequest(omRequest)).getListKeysResponse();
        keys.addAll(resp.getKeyInfoList().stream().map(OmKeyInfo::getFromProtobuf).collect(Collectors.toList()));
        return keys;
    }

    @Override
    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3CreateBucketRequest req = OzoneManagerProtocolProtos.S3CreateBucketRequest.newBuilder().setUserName(userName).setS3Bucketname(s3BucketName).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateS3Bucket).setCreateS3BucketRequest(req).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public void deleteS3Bucket(String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3DeleteBucketRequest request = OzoneManagerProtocolProtos.S3DeleteBucketRequest.newBuilder().setS3BucketName(s3BucketName).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteS3Bucket).setDeleteS3BucketRequest(request).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        OzoneManagerProtocolProtos.S3BucketInfoRequest request = OzoneManagerProtocolProtos.S3BucketInfoRequest.newBuilder().setS3BucketName(s3BucketName).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InfoS3Bucket).setInfoS3BucketRequest(request).build();
        OzoneManagerProtocolProtos.S3BucketInfoResponse resp = this.handleError(this.submitRequest(omRequest)).getInfoS3BucketResponse();
        return resp.getOzoneMapping();
    }

    @Override
    public List<OmBucketInfo> listS3Buckets(String userName, String startKey, String prefix, int count) throws IOException {
        ArrayList<OmBucketInfo> buckets = new ArrayList<OmBucketInfo>();
        OzoneManagerProtocolProtos.S3ListBucketsRequest.Builder reqBuilder = OzoneManagerProtocolProtos.S3ListBucketsRequest.newBuilder();
        reqBuilder.setUserName(userName);
        reqBuilder.setCount(count);
        if (startKey != null) {
            reqBuilder.setStartKey(startKey);
        }
        if (prefix != null) {
            reqBuilder.setPrefix(prefix);
        }
        OzoneManagerProtocolProtos.S3ListBucketsRequest request = reqBuilder.build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListS3Buckets).setListS3BucketsRequest(request).build();
        OzoneManagerProtocolProtos.S3ListBucketsResponse resp = this.handleError(this.submitRequest(omRequest)).getListS3BucketsResponse();
        buckets.addAll(resp.getBucketInfoList().stream().map(OmBucketInfo::getFromProtobuf).collect(Collectors.toList()));
        return buckets;
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        OzoneManagerProtocolProtos.GetS3SecretRequest request = OzoneManagerProtocolProtos.GetS3SecretRequest.newBuilder().setKerberosID(kerberosID).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetS3Secret).setGetS3SecretRequest(request).build();
        OzoneManagerProtocolProtos.GetS3SecretResponse resp = this.handleError(this.submitRequest(omRequest)).getGetS3SecretResponse();
        return S3SecretValue.fromProtobuf(resp.getS3Secret());
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.Builder multipartInfoInitiateRequest = OzoneManagerProtocolProtos.MultipartInfoInitiateRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setFactor(omKeyArgs.getFactor()).addAllAcls(omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).setType(omKeyArgs.getType());
        multipartInfoInitiateRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.InitiateMultiPartUpload).setInitiateMultiPartUploadRequest(multipartInfoInitiateRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartInfoInitiateResponse resp = this.handleError(this.submitRequest(omRequest)).getInitiateMultiPartUploadResponse();
        return new OmMultipartInfo(resp.getVolumeName(), resp.getBucketName(), resp.getKeyName(), resp.getMultipartUploadID());
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientId) throws IOException {
        List<OmKeyLocationInfo> locationInfoList = omKeyArgs.getLocationInfoList();
        Preconditions.checkNotNull(locationInfoList);
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.Builder multipartCommitUploadPartRequest = OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID()).setIsMultipartKey(omKeyArgs.getIsMultipartKey()).setMultipartNumber(omKeyArgs.getMultipartUploadPartNumber()).setDataSize(omKeyArgs.getDataSize()).addAllKeyLocations(locationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList()));
        multipartCommitUploadPartRequest.setClientID(clientId);
        multipartCommitUploadPartRequest.setKeyArgs(keyArgs.build());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse response = this.handleError(this.submitRequest(omRequest)).getCommitMultiPartUploadResponse();
        OmMultipartCommitUploadPartInfo info = new OmMultipartCommitUploadPartInfo(response.getPartName());
        return info;
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadCompleteList multipartUploadList) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.Builder multipartUploadCompleteRequest = OzoneManagerProtocolProtos.MultipartUploadCompleteRequest.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).addAllAcls(omKeyArgs.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        multipartUploadCompleteRequest.setKeyArgs(keyArgs.build());
        multipartUploadCompleteRequest.addAllPartsList(multipartUploadList.getPartsList());
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CompleteMultiPartUpload).setCompleteMultiPartUploadRequest(multipartUploadCompleteRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadCompleteResponse response = this.handleError(this.submitRequest(omRequest)).getCompleteMultiPartUploadResponse();
        OmMultipartUploadCompleteInfo info = new OmMultipartUploadCompleteInfo(response.getVolume(), response.getBucket(), response.getKey(), response.getHash());
        return info;
    }

    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setMultipartUploadID(omKeyArgs.getMultipartUploadID());
        OzoneManagerProtocolProtos.MultipartUploadAbortRequest.Builder multipartUploadAbortRequest = OzoneManagerProtocolProtos.MultipartUploadAbortRequest.newBuilder();
        multipartUploadAbortRequest.setKeyArgs(keyArgs);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AbortMultiPartUpload).setAbortMultiPartUploadRequest(multipartUploadAbortRequest.build()).build();
        this.handleError(this.submitRequest(omRequest));
    }

    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.Builder multipartUploadListPartsRequest = OzoneManagerProtocolProtos.MultipartUploadListPartsRequest.newBuilder();
        multipartUploadListPartsRequest.setVolume(volumeName).setBucket(bucketName).setKey(keyName).setUploadID(uploadID).setPartNumbermarker(partNumberMarker).setMaxParts(maxParts);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultiPartUploadParts).setListMultipartUploadPartsRequest(multipartUploadListPartsRequest.build()).build();
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse response = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadPartsResponse();
        OmMultipartUploadListParts omMultipartUploadListParts = new OmMultipartUploadListParts(response.getType(), response.getFactor(), response.getNextPartNumberMarker(), response.getIsTruncated());
        omMultipartUploadListParts.addProtoPartList(response.getPartsListList());
        return omMultipartUploadListParts;
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws IOException {
        OzoneManagerProtocolProtos.ListMultipartUploadsRequest request = OzoneManagerProtocolProtos.ListMultipartUploadsRequest.newBuilder().setVolume(volumeName).setBucket(bucketName).setPrefix(prefix == null ? "" : prefix).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListMultipartUploads).setListMultipartUploadsRequest(request).build();
        OzoneManagerProtocolProtos.ListMultipartUploadsResponse listMultipartUploadsResponse = this.handleError(this.submitRequest(omRequest)).getListMultipartUploadsResponse();
        List<OmMultipartUpload> uploadList = listMultipartUploadsResponse.getUploadsListList().stream().map(proto -> new OmMultipartUpload(proto.getVolumeName(), proto.getBucketName(), proto.getKeyName(), proto.getUploadId(), Instant.ofEpochMilli(proto.getCreationTime()), proto.getType(), proto.getFactor())).collect(Collectors.toList());
        OmMultipartUploadList response = new OmMultipartUploadList(uploadList);
        return response;
    }

    @Override
    public List<ServiceInfo> getServiceList() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList());
    }

    @Override
    public ServiceInfoEx getServiceInfo() throws IOException {
        OzoneManagerProtocolProtos.ServiceListRequest req = OzoneManagerProtocolProtos.ServiceListRequest.newBuilder().build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ServiceList).setServiceListRequest(req).build();
        OzoneManagerProtocolProtos.ServiceListResponse resp = this.handleError(this.submitRequest(omRequest)).getServiceListResponse();
        return new ServiceInfoEx(resp.getServiceInfoList().stream().map(ServiceInfo::getFromProtobuf).collect(Collectors.toList()), resp.getCaCertificate());
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer == null ? "" : renewer.toString()).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetDelegationToken).setGetDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.GetDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getGetDelegationTokenResponse();
            return resp.getResponse().hasToken() ? OMPBHelper.convertToDelegationToken(resp.getResponse().getToken()) : null;
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Get delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenewDelegationToken).setRenewDelegationTokenRequest(req).build();
        try {
            OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto resp = this.handleError(this.submitRequest(omRequest)).getRenewDelegationTokenResponse();
            return resp.getResponse().getNewExpiryTime();
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Renew delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(OMPBHelper.convertToTokenProto(token)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CancelDelegationToken).setCancelDelegationTokenRequest(req).build();
        try {
            this.handleError(this.submitRequest(omRequest));
        }
        catch (IOException e) {
            if (e instanceof OMException) {
                throw (OMException)e;
            }
            throw new OMException("Cancel delegation token failed.", e, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OzoneManagerProtocolProtos.GetFileStatusRequest req = OzoneManagerProtocolProtos.GetFileStatusRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetFileStatus).setGetFileStatusRequest(req).build();
        OzoneManagerProtocolProtos.GetFileStatusResponse resp = this.handleError(this.submitRequest(omRequest)).getGetFileStatusResponse();
        return OzoneFileStatus.getFromProtobuf(resp.getStatus());
    }

    @Override
    public void createDirectory(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).addAllAcls(args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).build();
        OzoneManagerProtocolProtos.CreateDirectoryRequest request = OzoneManagerProtocolProtos.CreateDirectoryRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateDirectory).setCreateDirectoryRequest(request).build();
        OzoneManagerProtocolProtos.OMResponse omResponse = this.submitRequest(omRequest);
        if (!omResponse.getStatus().equals(OzoneManagerProtocolProtos.Status.DIRECTORY_ALREADY_EXISTS)) {
            this.handleError(omResponse);
        }
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setSortDatanodes(args.getSortDatanodes()).build();
        OzoneManagerProtocolProtos.LookupFileRequest lookupFileRequest = OzoneManagerProtocolProtos.LookupFileRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.LookupFile).setLookupFileRequest(lookupFileRequest).build();
        OzoneManagerProtocolProtos.LookupFileResponse resp = this.handleError(this.submitRequest(omRequest)).getLookupFileResponse();
        return OmKeyInfo.getFromProtobuf(resp.getKeyInfo());
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.AddAclRequest req = OzoneManagerProtocolProtos.AddAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.AddAcl).setAddAclRequest(req).build();
        OzoneManagerProtocolProtos.AddAclResponse addAclResponse = this.handleError(this.submitRequest(omRequest)).getAddAclResponse();
        return addAclResponse.getResponse();
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        OzoneManagerProtocolProtos.RemoveAclRequest req = OzoneManagerProtocolProtos.RemoveAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).setAcl(OzoneAcl.toProtobuf(acl)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RemoveAcl).setRemoveAclRequest(req).build();
        OzoneManagerProtocolProtos.RemoveAclResponse response = this.handleError(this.submitRequest(omRequest)).getRemoveAclResponse();
        return response.getResponse();
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        OzoneManagerProtocolProtos.SetAclRequest.Builder builder = OzoneManagerProtocolProtos.SetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj));
        acls.forEach(a -> builder.addAcl(OzoneAcl.toProtobuf(a)));
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.SetAcl).setSetAclRequest(builder.build()).build();
        OzoneManagerProtocolProtos.SetAclResponse response = this.handleError(this.submitRequest(omRequest)).getSetAclResponse();
        return response.getResponse();
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        OzoneManagerProtocolProtos.GetAclRequest req = OzoneManagerProtocolProtos.GetAclRequest.newBuilder().setObj(OzoneObj.toProtobuf(obj)).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.GetAcl).setGetAclRequest(req).build();
        OzoneManagerProtocolProtos.GetAclResponse response = this.handleError(this.submitRequest(omRequest)).getGetAclResponse();
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        response.getAclsList().stream().forEach(a -> acls.add(OzoneAcl.fromProtobuf(a)));
        return acls;
    }

    @Override
    public DBUpdatesWrapper getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws IOException {
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DBUpdates).setDbUpdatesRequest(dbUpdatesRequest).build();
        OzoneManagerProtocolProtos.DBUpdatesResponse dbUpdatesResponse = this.handleError(this.submitRequest(omRequest)).getDbUpdatesResponse();
        DBUpdatesWrapper dbUpdatesWrapper = new DBUpdatesWrapper();
        for (ByteString byteString : dbUpdatesResponse.getDataList()) {
            dbUpdatesWrapper.addWriteBatch(byteString.toByteArray(), 0L);
        }
        dbUpdatesWrapper.setCurrentSequenceNumber(dbUpdatesResponse.getSequenceNumber());
        return dbUpdatesWrapper;
    }

    @Override
    public OpenKeySession createFile(OmKeyArgs args, boolean overWrite, boolean recursive) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).setDataSize(args.getDataSize()).setType(args.getType()).setFactor(args.getFactor()).addAllAcls(args.getAcls().stream().map(a -> OzoneAcl.toProtobuf(a)).collect(Collectors.toList())).build();
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = OzoneManagerProtocolProtos.CreateFileRequest.newBuilder().setKeyArgs(keyArgs).setIsOverwrite(overWrite).setIsRecursive(recursive).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.CreateFile).setCreateFileRequest(createFileRequest).build();
        OzoneManagerProtocolProtos.CreateFileResponse resp = this.handleError(this.submitRequest(omRequest)).getCreateFileResponse();
        return new OpenKeySession(resp.getID(), OmKeyInfo.getFromProtobuf(resp.getKeyInfo()), resp.getOpenVersion());
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(args.getVolumeName()).setBucketName(args.getBucketName()).setKeyName(args.getKeyName()).build();
        OzoneManagerProtocolProtos.ListStatusRequest listStatusRequest = OzoneManagerProtocolProtos.ListStatusRequest.newBuilder().setKeyArgs(keyArgs).setRecursive(recursive).setStartKey(startKey).setNumEntries(numEntries).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListStatus).setListStatusRequest(listStatusRequest).build();
        OzoneManagerProtocolProtos.ListStatusResponse listStatusResponse = this.handleError(this.submitRequest(omRequest)).getListStatusResponse();
        ArrayList<OzoneFileStatus> statusList = new ArrayList<OzoneFileStatus>(listStatusResponse.getStatusesCount());
        for (OzoneManagerProtocolProtos.OzoneFileStatusProto fileStatus : listStatusResponse.getStatusesList()) {
            statusList.add(OzoneFileStatus.getFromProtobuf(fileStatus));
        }
        return statusList;
    }

    @Override
    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkArgument(Strings.isNullOrEmpty(volumeName), "The volume name cannot be null or empty.  Please enter a valid volume name or use '*' as a wild card");
        Preconditions.checkArgument(Strings.isNullOrEmpty(bucketName), "The bucket name cannot be null or empty.  Please enter a valid bucket name or use '*' as a wild card");
        OzoneManagerProtocolProtos.ListTrashRequest trashRequest = OzoneManagerProtocolProtos.ListTrashRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setStartKeyName(startKeyName).setKeyPrefix(keyPrefix).setMaxKeys(maxKeys).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.ListTrash).setListTrashRequest(trashRequest).build();
        OzoneManagerProtocolProtos.ListTrashResponse trashResponse = this.handleError(this.submitRequest(omRequest)).getListTrashResponse();
        ArrayList<RepeatedOmKeyInfo> deletedKeyList = new ArrayList<RepeatedOmKeyInfo>(trashResponse.getDeletedKeysCount());
        deletedKeyList.addAll(trashResponse.getDeletedKeysList().stream().map(RepeatedOmKeyInfo::getFromProto).collect(Collectors.toList()));
        return deletedKeyList;
    }

    @Override
    public boolean recoverTrash(String volumeName, String bucketName, String keyName, String destinationBucket) throws IOException {
        Preconditions.checkArgument(Strings.isNullOrEmpty(volumeName), "The volume name cannot be null or empty. Please enter a valid volume name.");
        Preconditions.checkArgument(Strings.isNullOrEmpty(bucketName), "The bucket name cannot be null or empty. Please enter a valid bucket name.");
        Preconditions.checkArgument(Strings.isNullOrEmpty(keyName), "The key name cannot be null or empty. Please enter a valid key name.");
        Preconditions.checkArgument(Strings.isNullOrEmpty(destinationBucket), "The destination bucket name cannot be null or empty. Please enter a valid destination bucket name.");
        OzoneManagerProtocolProtos.RecoverTrashRequest recoverRequest = OzoneManagerProtocolProtos.RecoverTrashRequest.newBuilder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDestinationBucket(destinationBucket).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RecoverTrash).setRecoverTrashRequest(recoverRequest).build();
        OzoneManagerProtocolProtos.RecoverTrashResponse recoverResponse = this.handleError(this.submitRequest(omRequest)).getRecoverTrashResponse();
        return recoverResponse.getResponse();
    }
}

