/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class VolumeArgs {
    private final String adminName;
    private final String ownerName;
    private final String volume;
    private final long quotaInBytes;
    private final Map<String, String> extendedAttributes;

    private VolumeArgs(String adminName, String ownerName, String volume, long quotaInBytes, Map<String, String> keyValueMap) {
        this.adminName = adminName;
        this.ownerName = ownerName;
        this.volume = volume;
        this.quotaInBytes = quotaInBytes;
        this.extendedAttributes = keyValueMap;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getVolume() {
        return this.volume;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public Map<String, String> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    static class Builder {
        private String adminName;
        private String ownerName;
        private String volume;
        private long quotaInBytes;
        private Map<String, String> extendedAttributes = new HashMap<String, String>();

        Builder() {
        }

        public void setAdminName(String adminName) {
            this.adminName = adminName;
        }

        public void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public void setVolume(String volume) {
            this.volume = volume;
        }

        public void setQuotaInBytes(long quotaInBytes) {
            this.quotaInBytes = quotaInBytes;
        }

        public void addMetadata(String key, String value) {
            this.extendedAttributes.put(key, value);
        }

        public VolumeArgs build() {
            Preconditions.checkNotNull(this.adminName);
            Preconditions.checkNotNull(this.ownerName);
            Preconditions.checkNotNull(this.volume);
            return new VolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, this.extendedAttributes);
        }
    }
}

