/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class ServiceInfo {
    private static final ObjectReader READER = new ObjectMapper().readerFor(ServiceInfo.class);
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private HddsProtos.NodeType nodeType;
    private String hostname;
    private Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> ports;
    private OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo;

    public ServiceInfo() {
    }

    private ServiceInfo(HddsProtos.NodeType nodeType, String hostname, List<OzoneManagerProtocolProtos.ServicePort> portList, OzoneManagerProtocolProtos.OMRoleInfo omRole) {
        Preconditions.checkNotNull(nodeType);
        Preconditions.checkNotNull(hostname);
        this.nodeType = nodeType;
        this.hostname = hostname;
        this.ports = new HashMap<OzoneManagerProtocolProtos.ServicePort.Type, Integer>();
        for (OzoneManagerProtocolProtos.ServicePort port : portList) {
            this.ports.put(port.getType(), port.getValue());
        }
        this.omRoleInfo = omRole;
    }

    public HddsProtos.NodeType getNodeType() {
        return this.nodeType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<OzoneManagerProtocolProtos.ServicePort.Type, Integer> getPorts() {
        return this.ports;
    }

    @JsonIgnore
    public int getPort(OzoneManagerProtocolProtos.ServicePort.Type type) {
        return this.ports.get(type);
    }

    @JsonIgnore
    public String getServiceAddress(OzoneManagerProtocolProtos.ServicePort.Type portType) {
        return this.hostname + ":" + this.getPort(portType);
    }

    @JsonIgnore
    public OzoneManagerProtocolProtos.OMRoleInfo getOmRoleInfo() {
        return this.omRoleInfo;
    }

    @JsonIgnore
    public OzoneManagerProtocolProtos.ServiceInfo getProtobuf() {
        OzoneManagerProtocolProtos.ServiceInfo.Builder builder = OzoneManagerProtocolProtos.ServiceInfo.newBuilder();
        builder.setNodeType(this.nodeType).setHostname(this.hostname).addAllServicePorts(this.ports.entrySet().stream().map(entry -> OzoneManagerProtocolProtos.ServicePort.newBuilder().setType((OzoneManagerProtocolProtos.ServicePort.Type)entry.getKey()).setValue((Integer)entry.getValue()).build()).collect(Collectors.toList()));
        if (this.nodeType == HddsProtos.NodeType.OM && this.omRoleInfo != null) {
            builder.setOmRole(this.omRoleInfo);
        }
        return builder.build();
    }

    @JsonIgnore
    public static ServiceInfo getFromProtobuf(OzoneManagerProtocolProtos.ServiceInfo serviceInfo) {
        return new ServiceInfo(serviceInfo.getNodeType(), serviceInfo.getHostname(), serviceInfo.getServicePortsList(), serviceInfo.hasOmRole() ? serviceInfo.getOmRole() : null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HddsProtos.NodeType node;
        private String host;
        private List<OzoneManagerProtocolProtos.ServicePort> portList = new ArrayList<OzoneManagerProtocolProtos.ServicePort>();
        private OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo;

        public Builder setNodeType(HddsProtos.NodeType nodeType) {
            this.node = nodeType;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.host = hostname;
            return this;
        }

        public Builder addServicePort(OzoneManagerProtocolProtos.ServicePort servicePort) {
            this.portList.add(servicePort);
            return this;
        }

        public Builder setOmRoleInfo(OzoneManagerProtocolProtos.OMRoleInfo omRole) {
            this.omRoleInfo = omRole;
            return this;
        }

        public ServiceInfo build() {
            return new ServiceInfo(this.node, this.host, this.portList, this.omRoleInfo);
        }
    }
}

