/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.protocolPB.PBHelper;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OzoneFileStatus
extends FileStatus {
    private static final long serialVersionUID = 1L;
    private transient OmKeyInfo keyInfo;

    public OzoneFileStatus(OmKeyInfo key, long blockSize, boolean isDirectory) {
        super(key.getDataSize(), isDirectory, key.getFactor().getNumber(), blockSize, key.getModificationTime(), OzoneFileStatus.getPath(key.getKeyName()));
        this.keyInfo = key;
    }

    public OzoneFileStatus(FileStatus status, OmKeyInfo key) throws IOException {
        super(status);
        this.keyInfo = key;
    }

    public OzoneFileStatus(String keyName) {
        super(0L, true, 0, 0L, 0L, OzoneFileStatus.getPath(keyName));
    }

    public OzoneManagerProtocolProtos.OzoneFileStatusProto getProtobuf() throws IOException {
        OzoneManagerProtocolProtos.OzoneFileStatusProto.Builder builder = OzoneManagerProtocolProtos.OzoneFileStatusProto.newBuilder().setStatus(PBHelper.convert((FileStatus)this));
        if (this.keyInfo != null) {
            builder.setKeyInfo(this.keyInfo.getProtobuf());
        }
        return builder.build();
    }

    public static OzoneFileStatus getFromProtobuf(OzoneManagerProtocolProtos.OzoneFileStatusProto response) throws IOException {
        return new OzoneFileStatus(PBHelper.convert((FSProtos.FileStatusProto)response.getStatus()), OmKeyInfo.getFromProtobuf(response.getKeyInfo()));
    }

    public static Path getPath(String keyName) {
        return new Path("/" + keyName);
    }

    public FileStatus makeQualified(URI defaultUri, Path parent, String owner, String group) {
        this.setPath(parent.makeQualified(defaultUri, null));
        this.setGroup(group);
        this.setOwner(owner);
        if (this.isDirectory()) {
            this.setPermission(FsPermission.getDirDefault());
        } else {
            this.setPermission(FsPermission.getFileDefault());
        }
        return this;
    }

    public long getModificationTime() {
        if (this.isDirectory() && super.getModificationTime() == 0L) {
            return System.currentTimeMillis();
        }
        return super.getModificationTime();
    }

    public OmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

