/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class OmPrefixInfo
extends WithObjectID {
    private String name;
    private List<OzoneAcl> acls;

    public OmPrefixInfo(String name, List<OzoneAcl> acls, Map<String, String> metadata, long objectId, long updateId) {
        this.name = name;
        this.acls = acls;
        this.metadata = metadata;
        this.objectID = objectId;
        this.updateID = updateId;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public OzoneManagerProtocolProtos.PrefixInfo getProtobuf() {
        OzoneManagerProtocolProtos.PrefixInfo.Builder pib = OzoneManagerProtocolProtos.PrefixInfo.newBuilder().setName(this.name).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata));
        if (this.acls != null) {
            pib.addAllAcls(OzoneAclUtil.toProtobuf(this.acls));
        }
        return pib.build();
    }

    public static OmPrefixInfo getFromProtobuf(OzoneManagerProtocolProtos.PrefixInfo prefixInfo) {
        Builder opib = OmPrefixInfo.newBuilder().setName(prefixInfo.getName());
        if (prefixInfo.getMetadataList() != null) {
            opib.addAllMetadata(KeyValueUtil.getFromProtobuf(prefixInfo.getMetadataList()));
        }
        if (prefixInfo.getAclsList() != null) {
            opib.setAcls(OzoneAclUtil.fromProtobuf(prefixInfo.getAclsList()));
        }
        return opib.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmPrefixInfo that = (OmPrefixInfo)o;
        return this.name.equals(that.name) && Objects.equals(this.acls, that.acls) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public OmPrefixInfo copyObject() {
        List<OzoneAcl> aclList = this.acls.stream().map(acl -> new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())).collect(Collectors.toList());
        HashMap<String, String> metadataList = new HashMap<String, String>();
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> metadataList.put((String)k, (String)v));
        }
        return new OmPrefixInfo(this.name, aclList, metadataList, this.objectID, this.updateID);
    }

    public static class Builder {
        private String name;
        private List<OzoneAcl> acls = new LinkedList<OzoneAcl>();
        private Map<String, String> metadata = new HashMap<String, String>();
        private long objectID;
        private long updateID;

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder setName(String n) {
            this.name = n;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public OmPrefixInfo build() {
            Preconditions.checkNotNull(this.name);
            return new OmPrefixInfo(this.name, this.acls, this.metadata, this.objectID, this.updateID);
        }
    }
}

