/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmKeyLocationInfoGroup {
    private final long version;
    private final List<OmKeyLocationInfo> locationList;

    public OmKeyLocationInfoGroup(long version, List<OmKeyLocationInfo> locations) {
        this.version = version;
        this.locationList = locations;
    }

    public List<OmKeyLocationInfo> getBlocksLatestVersionOnly() {
        ArrayList<OmKeyLocationInfo> list = new ArrayList<OmKeyLocationInfo>();
        this.locationList.stream().filter(x -> x.getCreateVersion() == this.version).forEach(list::add);
        return list;
    }

    public long getVersion() {
        return this.version;
    }

    public List<OmKeyLocationInfo> getLocationList() {
        return this.locationList;
    }

    public OzoneManagerProtocolProtos.KeyLocationList getProtobuf() {
        return OzoneManagerProtocolProtos.KeyLocationList.newBuilder().setVersion(this.version).addAllKeyLocations(this.locationList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList())).build();
    }

    public static OmKeyLocationInfoGroup getFromProtobuf(OzoneManagerProtocolProtos.KeyLocationList keyLocationList) {
        return new OmKeyLocationInfoGroup(keyLocationList.getVersion(), keyLocationList.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList()));
    }

    OmKeyLocationInfoGroup generateNextVersion(List<OmKeyLocationInfo> newLocationList) throws IOException {
        ArrayList<OmKeyLocationInfo> newList = new ArrayList<OmKeyLocationInfo>();
        newList.addAll(this.locationList);
        for (OmKeyLocationInfo newInfo : newLocationList) {
            newInfo.setCreateVersion(this.version + 1L);
            newList.add(newInfo);
        }
        return new OmKeyLocationInfoGroup(this.version + 1L, newList);
    }

    void appendNewBlocks(List<OmKeyLocationInfo> newLocationList) throws IOException {
        for (OmKeyLocationInfo info : newLocationList) {
            info.setCreateVersion(this.version);
            this.locationList.add(info);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version:").append(this.version).append(" ");
        for (OmKeyLocationInfo kli : this.locationList) {
            sb.append(kli.getLocalID()).append(" || ");
        }
        return sb.toString();
    }
}

