/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;

public final class OmKeyInfo
extends WithObjectID {
    private final String volumeName;
    private final String bucketName;
    private String keyName;
    private long dataSize;
    private List<OmKeyLocationInfoGroup> keyLocationVersions;
    private final long creationTime;
    private long modificationTime;
    private HddsProtos.ReplicationType type;
    private HddsProtos.ReplicationFactor factor;
    private FileEncryptionInfo encInfo;
    private List<OzoneAcl> acls;

    OmKeyInfo(String volumeName, String bucketName, String keyName, List<OmKeyLocationInfoGroup> versions, long dataSize, long creationTime, long modificationTime, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, Map<String, String> metadata, FileEncryptionInfo encInfo, List<OzoneAcl> acls, long objectID, long updateID) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        long currentVersion = -1L;
        for (OmKeyLocationInfoGroup version : versions) {
            Preconditions.checkArgument(currentVersion + 1L == version.getVersion());
            currentVersion = version.getVersion();
        }
        this.keyLocationVersions = versions;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.factor = factor;
        this.type = type;
        this.metadata = metadata;
        this.encInfo = encInfo;
        this.acls = acls;
        this.objectID = objectID;
        this.updateID = updateID;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public synchronized OmKeyLocationInfoGroup getLatestVersionLocations() {
        return this.keyLocationVersions.size() == 0 ? null : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
    }

    public List<OmKeyLocationInfoGroup> getKeyLocationVersions() {
        return this.keyLocationVersions;
    }

    public void updateModifcationTime() {
        this.modificationTime = Time.monotonicNow();
    }

    public void updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        long latestVersion = this.getLatestVersionLocations().getVersion();
        OmKeyLocationInfoGroup keyLocationInfoGroup = this.getLatestVersionLocations();
        List<OmKeyLocationInfo> currentList = keyLocationInfoGroup.getLocationList();
        List<OmKeyLocationInfo> latestVersionList = keyLocationInfoGroup.getBlocksLatestVersionOnly();
        currentList.removeAll(latestVersionList);
        locationInfoList.stream().forEach(omKeyLocationInfo -> omKeyLocationInfo.setCreateVersion(latestVersion));
        currentList.addAll(locationInfoList);
    }

    public synchronized void appendNewBlocks(List<OmKeyLocationInfo> newLocationList, boolean updateTime) throws IOException {
        if (this.keyLocationVersions.size() == 0) {
            throw new IOException("Appending new block, but no version exist");
        }
        OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
        currentLatestVersion.appendNewBlocks(newLocationList);
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
    }

    public synchronized long addNewVersion(List<OmKeyLocationInfo> newLocationList, boolean updateTime) throws IOException {
        long latestVersionNum;
        if (this.keyLocationVersions.size() == 0) {
            this.keyLocationVersions.add(new OmKeyLocationInfoGroup(0L, newLocationList));
            latestVersionNum = 0L;
        } else {
            OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
            OmKeyLocationInfoGroup newVersion = currentLatestVersion.generateNextVersion(newLocationList);
            this.keyLocationVersions.add(newVersion);
            latestVersionNum = newVersion.getVersion();
        }
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
        return latestVersionNum;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.encInfo;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf() {
        long latestVersion = this.keyLocationVersions.size() == 0 ? -1L : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getVersion();
        OzoneManagerProtocolProtos.KeyInfo.Builder kb = OzoneManagerProtocolProtos.KeyInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setDataSize(this.dataSize).setFactor(this.factor).setType(this.type).addAllKeyLocationList(this.keyLocationVersions.stream().map(OmKeyLocationInfoGroup::getProtobuf).collect(Collectors.toList())).setLatestVersion(latestVersion).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata)).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setObjectID(this.objectID).setUpdateID(this.updateID);
        if (this.encInfo != null) {
            kb.setFileEncryptionInfo(OMPBHelper.convert(this.encInfo));
        }
        return kb.build();
    }

    public static OmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo keyInfo) {
        Builder builder = new Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(keyInfo.getKeyName()).setOmKeyLocationInfos(keyInfo.getKeyLocationListList().stream().map(OmKeyLocationInfoGroup::getFromProtobuf).collect(Collectors.toList())).setDataSize(keyInfo.getDataSize()).setCreationTime(keyInfo.getCreationTime()).setModificationTime(keyInfo.getModificationTime()).setReplicationType(keyInfo.getType()).setReplicationFactor(keyInfo.getFactor()).addAllMetadata(KeyValueUtil.getFromProtobuf(keyInfo.getMetadataList())).setFileEncryptionInfo(keyInfo.hasFileEncryptionInfo() ? OMPBHelper.convert(keyInfo.getFileEncryptionInfo()) : null).setAcls(OzoneAclUtil.fromProtobuf(keyInfo.getAclsList()));
        if (keyInfo.hasObjectID()) {
            builder.setObjectID(keyInfo.getObjectID());
        }
        if (keyInfo.hasUpdateID()) {
            builder.setUpdateID(keyInfo.getUpdateID());
        }
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return "OMKeyInfo{volume='" + this.volumeName + '\'' + ", bucket='" + this.bucketName + '\'' + ", key='" + this.keyName + '\'' + ", dataSize='" + this.dataSize + '\'' + ", creationTime='" + this.creationTime + '\'' + ", type='" + this.type + '\'' + ", factor='" + this.factor + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmKeyInfo omKeyInfo = (OmKeyInfo)o;
        return this.dataSize == omKeyInfo.dataSize && this.creationTime == omKeyInfo.creationTime && this.modificationTime == omKeyInfo.modificationTime && this.volumeName.equals(omKeyInfo.volumeName) && this.bucketName.equals(omKeyInfo.bucketName) && this.keyName.equals(omKeyInfo.keyName) && Objects.equals(this.keyLocationVersions, omKeyInfo.keyLocationVersions) && this.type == omKeyInfo.type && this.factor == omKeyInfo.factor && Objects.equals(this.metadata, omKeyInfo.metadata) && Objects.equals(this.acls, omKeyInfo.acls) && this.objectID == omKeyInfo.objectID && this.updateID == omKeyInfo.updateID;
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName);
    }

    public OmKeyInfo copyObject() {
        Builder builder = new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setDataSize(this.dataSize).setReplicationType(this.type).setReplicationFactor(this.factor).setFileEncryptionInfo(this.encInfo).setObjectID(this.objectID).setUpdateID(this.updateID);
        this.keyLocationVersions.forEach(keyLocationVersion -> {
            ArrayList<OmKeyLocationInfo> keyLocationInfos = new ArrayList<OmKeyLocationInfo>();
            keyLocationInfos.addAll(keyLocationVersion.getLocationList());
            builder.addOmKeyLocationInfoGroup(new OmKeyLocationInfoGroup(keyLocationVersion.getVersion(), keyLocationInfos));
        });
        this.acls.forEach(acl -> builder.addAcl(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> builder.addMetadata((String)k, (String)v));
        }
        return builder.build();
    }

    public void clearFileEncryptionInfo() {
        this.encInfo = null;
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups = new ArrayList<OmKeyLocationInfoGroup>();
        private long creationTime;
        private long modificationTime;
        private HddsProtos.ReplicationType type;
        private HddsProtos.ReplicationFactor factor;
        private Map<String, String> metadata = new HashMap<String, String>();
        private FileEncryptionInfo encInfo;
        private List<OzoneAcl> acls;
        private long objectID;
        private long updateID;

        public Builder() {
            this.omKeyLocationInfoGroups = new ArrayList<OmKeyLocationInfoGroup>();
            this.acls = new ArrayList<OzoneAcl>();
        }

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setOmKeyLocationInfos(List<OmKeyLocationInfoGroup> omKeyLocationInfoList) {
            if (omKeyLocationInfoList != null) {
                this.omKeyLocationInfoGroups.addAll(omKeyLocationInfoList);
            }
            return this;
        }

        public Builder addOmKeyLocationInfoGroup(OmKeyLocationInfoGroup omKeyLocationInfoGroup) {
            if (omKeyLocationInfoGroup != null) {
                this.omKeyLocationInfoGroups.add(omKeyLocationInfoGroup);
            }
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setModificationTime(long mTime) {
            this.modificationTime = mTime;
            return this;
        }

        public Builder setReplicationFactor(HddsProtos.ReplicationFactor replFact) {
            this.factor = replFact;
            return this;
        }

        public Builder setReplicationType(HddsProtos.ReplicationType replType) {
            this.type = replType;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> newMetadata) {
            this.metadata.putAll(newMetadata);
            return this;
        }

        public Builder setFileEncryptionInfo(FileEncryptionInfo feInfo) {
            this.encInfo = feInfo;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public OmKeyInfo build() {
            return new OmKeyInfo(this.volumeName, this.bucketName, this.keyName, this.omKeyLocationInfoGroups, this.dataSize, this.creationTime, this.modificationTime, this.type, this.factor, this.metadata, this.encInfo, this.acls, this.objectID, this.updateID);
        }
    }
}

