/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public final class OmKeyArgs
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private final String keyName;
    private long dataSize;
    private final HddsProtos.ReplicationType type;
    private final HddsProtos.ReplicationFactor factor;
    private List<OmKeyLocationInfo> locationInfoList;
    private final boolean isMultipartKey;
    private final String multipartUploadID;
    private final int multipartUploadPartNumber;
    private Map<String, String> metadata;
    private boolean refreshPipeline;
    private boolean sortDatanodesInPipeline;
    private List<OzoneAcl> acls;

    private OmKeyArgs(String volumeName, String bucketName, String keyName, long dataSize, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<OmKeyLocationInfo> locationInfoList, boolean isMultipart, String uploadID, int partNumber, Map<String, String> metadataMap, boolean refreshPipeline, List<OzoneAcl> acls, boolean sortDatanode) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        this.type = type;
        this.factor = factor;
        this.locationInfoList = locationInfoList;
        this.isMultipartKey = isMultipart;
        this.multipartUploadID = uploadID;
        this.multipartUploadPartNumber = partNumber;
        this.metadata = metadataMap;
        this.refreshPipeline = refreshPipeline;
        this.acls = acls;
        this.sortDatanodesInPipeline = sortDatanode;
    }

    public boolean getIsMultipartKey() {
        return this.isMultipartKey;
    }

    public String getMultipartUploadID() {
        return this.multipartUploadID;
    }

    public int getMultipartUploadPartNumber() {
        return this.multipartUploadPartNumber;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setLocationInfoList(List<OmKeyLocationInfo> locationInfoList) {
        this.locationInfoList = locationInfoList;
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        return this.locationInfoList;
    }

    public boolean getRefreshPipeline() {
        return this.refreshPipeline;
    }

    public boolean getSortDatanodes() {
        return this.sortDatanodesInPipeline;
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("key", this.keyName);
        auditMap.put("dataSize", String.valueOf(this.dataSize));
        auditMap.put("replicationType", this.type != null ? this.type.name() : null);
        auditMap.put("replicationFactor", this.factor != null ? this.factor.name() : null);
        return auditMap;
    }

    @VisibleForTesting
    public void addLocationInfo(OmKeyLocationInfo locationInfo) {
        if (this.locationInfoList == null) {
            this.locationInfoList = new ArrayList<OmKeyLocationInfo>();
        }
        this.locationInfoList.add(locationInfo);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private HddsProtos.ReplicationType type;
        private HddsProtos.ReplicationFactor factor;
        private List<OmKeyLocationInfo> locationInfoList;
        private boolean isMultipartKey;
        private String multipartUploadID;
        private int multipartUploadPartNumber;
        private Map<String, String> metadata = new HashMap<String, String>();
        private boolean refreshPipeline;
        private boolean sortDatanodesInPipeline;
        private List<OzoneAcl> acls;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setType(HddsProtos.ReplicationType replicationType) {
            this.type = replicationType;
            return this;
        }

        public Builder setFactor(HddsProtos.ReplicationFactor replicationFactor) {
            this.factor = replicationFactor;
            return this;
        }

        public Builder setLocationInfoList(List<OmKeyLocationInfo> locationInfos) {
            this.locationInfoList = locationInfos;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            this.acls = listOfAcls;
            return this;
        }

        public Builder setIsMultipartKey(boolean isMultipart) {
            this.isMultipartKey = isMultipart;
            return this;
        }

        public Builder setMultipartUploadID(String uploadID) {
            this.multipartUploadID = uploadID;
            return this;
        }

        public Builder setMultipartUploadPartNumber(int partNumber) {
            this.multipartUploadPartNumber = partNumber;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> metadatamap) {
            this.metadata.putAll(metadatamap);
            return this;
        }

        public Builder setRefreshPipeline(boolean refresh) {
            this.refreshPipeline = refresh;
            return this;
        }

        public Builder setSortDatanodesInPipeline(boolean sort) {
            this.sortDatanodesInPipeline = sort;
            return this;
        }

        public OmKeyArgs build() {
            return new OmKeyArgs(this.volumeName, this.bucketName, this.keyName, this.dataSize, this.type, this.factor, this.locationInfoList, this.isMultipartKey, this.multipartUploadID, this.multipartUploadPartNumber, this.metadata, this.refreshPipeline, this.acls, this.sortDatanodesInPipeline);
        }
    }
}

