/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class OmBucketInfo
extends WithObjectID
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private List<OzoneAcl> acls;
    private Boolean isVersionEnabled;
    private StorageType storageType;
    private final long creationTime;
    private BucketEncryptionKeyInfo bekInfo;

    private OmBucketInfo(String volumeName, String bucketName, List<OzoneAcl> acls, boolean isVersionEnabled, StorageType storageType, long creationTime, long objectID, long updateID, Map<String, String> metadata, BucketEncryptionKeyInfo bekInfo) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.acls = acls;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
        this.creationTime = creationTime;
        this.objectID = objectID;
        this.updateID = updateID;
        this.metadata = metadata;
        this.bekInfo = bekInfo;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.addAcl(this.acls, ozoneAcl);
    }

    public boolean removeAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.removeAcl(this.acls, ozoneAcl);
    }

    public boolean setAcls(List<OzoneAcl> ozoneAcls) {
        return OzoneAclUtil.setAcl(this.acls, ozoneAcls);
    }

    public boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public BucketEncryptionKeyInfo getEncryptionKeyInfo() {
        return this.bekInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("gdprEnabled", (String)this.metadata.get("gdprEnabled"));
        auditMap.put("acls", this.acls != null ? this.acls.toString() : null);
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        auditMap.put("storageType", this.storageType != null ? this.storageType.name() : null);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        return auditMap;
    }

    public OmBucketInfo copyObject() {
        Builder builder = new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setStorageType(this.storageType).setIsVersionEnabled(this.isVersionEnabled).setCreationTime(this.creationTime).setObjectID(this.objectID).setUpdateID(this.updateID).setBucketEncryptionKey(this.bekInfo != null ? new BucketEncryptionKeyInfo(this.bekInfo.getVersion(), this.bekInfo.getSuite(), this.bekInfo.getKeyName()) : null);
        this.acls.forEach(acl -> builder.addAcl(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> builder.addMetadata((String)k, (String)v));
        }
        return builder.build();
    }

    public OzoneManagerProtocolProtos.BucketInfo getProtobuf() {
        OzoneManagerProtocolProtos.BucketInfo.Builder bib = OzoneManagerProtocolProtos.BucketInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setIsVersionEnabled(this.isVersionEnabled).setStorageType(this.storageType.toProto()).setCreationTime(this.creationTime).setObjectID(this.objectID).setUpdateID(this.updateID).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata));
        if (this.bekInfo != null && this.bekInfo.getKeyName() != null) {
            bib.setBeinfo(OMPBHelper.convert(this.bekInfo));
        }
        return bib.build();
    }

    public static OmBucketInfo getFromProtobuf(OzoneManagerProtocolProtos.BucketInfo bucketInfo) {
        Builder obib = OmBucketInfo.newBuilder().setVolumeName(bucketInfo.getVolumeName()).setBucketName(bucketInfo.getBucketName()).setAcls(bucketInfo.getAclsList().stream().map(OzoneAcl::fromProtobuf).collect(Collectors.toList())).setIsVersionEnabled(bucketInfo.getIsVersionEnabled()).setStorageType(StorageType.valueOf(bucketInfo.getStorageType())).setCreationTime(bucketInfo.getCreationTime());
        if (bucketInfo.hasObjectID()) {
            obib.setObjectID(bucketInfo.getObjectID());
        }
        if (bucketInfo.hasUpdateID()) {
            obib.setUpdateID(bucketInfo.getUpdateID());
        }
        if (bucketInfo.getMetadataList() != null) {
            obib.addAllMetadata(KeyValueUtil.getFromProtobuf(bucketInfo.getMetadataList()));
        }
        if (bucketInfo.hasBeinfo()) {
            obib.setBucketEncryptionKey(OMPBHelper.convert(bucketInfo.getBeinfo()));
        }
        return obib.build();
    }

    @Override
    public String getObjectInfo() {
        return "OMBucketInfo{volume='" + this.volumeName + '\'' + ", bucket='" + this.bucketName + '\'' + ", isVersionEnabled='" + this.isVersionEnabled + '\'' + ", storageType='" + (Object)((Object)this.storageType) + '\'' + ", creationTime='" + this.creationTime + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmBucketInfo that = (OmBucketInfo)o;
        return this.creationTime == that.creationTime && this.volumeName.equals(that.volumeName) && this.bucketName.equals(that.bucketName) && Objects.equals(this.acls, that.acls) && Objects.equals(this.isVersionEnabled, that.isVersionEnabled) && this.storageType == that.storageType && this.objectID == that.objectID && this.updateID == that.updateID && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.bekInfo, that.bekInfo);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private List<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        private Boolean isVersionEnabled = false;
        private StorageType storageType = StorageType.DISK;
        private long creationTime;
        private long objectID;
        private long updateID;
        private Map<String, String> metadata = new HashMap<String, String>();
        private BucketEncryptionKeyInfo bekInfo;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            if (additionalMetadata != null) {
                this.metadata.putAll(additionalMetadata);
            }
            return this;
        }

        public Builder setBucketEncryptionKey(BucketEncryptionKeyInfo info) {
            this.bekInfo = info;
            return this;
        }

        public OmBucketInfo build() {
            Preconditions.checkNotNull(this.volumeName);
            Preconditions.checkNotNull(this.bucketName);
            Preconditions.checkNotNull(this.acls);
            Preconditions.checkNotNull(this.isVersionEnabled);
            Preconditions.checkNotNull(this.storageType);
            return new OmBucketInfo(this.volumeName, this.bucketName, this.acls, this.isVersionEnabled, this.storageType, this.creationTime, this.objectID, this.updateID, this.metadata, this.bekInfo);
        }
    }
}

