/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class OmBucketArgs
extends WithMetadata
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private Boolean isVersionEnabled;
    private StorageType storageType;

    private OmBucketArgs(String volumeName, String bucketName, Boolean isVersionEnabled, StorageType storageType, Map<String, String> metadata) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
        this.metadata = metadata;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("gdprEnabled", (String)this.metadata.get("gdprEnabled"));
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        if (this.storageType != null) {
            auditMap.put("storageType", this.storageType.name());
        }
        return auditMap;
    }

    public OzoneManagerProtocolProtos.BucketArgs getProtobuf() {
        OzoneManagerProtocolProtos.BucketArgs.Builder builder = OzoneManagerProtocolProtos.BucketArgs.newBuilder();
        builder.setVolumeName(this.volumeName).setBucketName(this.bucketName);
        if (this.isVersionEnabled != null) {
            builder.setIsVersionEnabled(this.isVersionEnabled);
        }
        if (this.storageType != null) {
            builder.setStorageType(this.storageType.toProto());
        }
        return builder.build();
    }

    public static OmBucketArgs getFromProtobuf(OzoneManagerProtocolProtos.BucketArgs bucketArgs) {
        return new OmBucketArgs(bucketArgs.getVolumeName(), bucketArgs.getBucketName(), bucketArgs.hasIsVersionEnabled() ? Boolean.valueOf(bucketArgs.getIsVersionEnabled()) : null, bucketArgs.hasStorageType() ? StorageType.valueOf(bucketArgs.getStorageType()) : null, KeyValueUtil.getFromProtobuf(bucketArgs.getMetadataList()));
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private Boolean isVersionEnabled;
        private StorageType storageType;
        private Map<String, String> metadata;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder addMetadata(Map<String, String> metadataMap) {
            this.metadata = metadataMap;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public OmBucketArgs build() {
            Preconditions.checkNotNull(this.volumeName);
            Preconditions.checkNotNull(this.bucketName);
            return new OmBucketArgs(this.volumeName, this.bucketName, this.isVersionEnabled, this.storageType, this.metadata);
        }
    }
}

