/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMRatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OMRatisHelper.class);

    private OMRatisHelper() {
    }

    static RaftPeerId getRaftPeerId(String omId) {
        return RaftPeerId.valueOf(omId);
    }

    public static ByteString convertRequestToByteString(OzoneManagerProtocolProtos.OMRequest request) {
        byte[] requestBytes = request.toByteArray();
        return ByteString.copyFrom(requestBytes);
    }

    public static OzoneManagerProtocolProtos.OMRequest convertByteStringToOMRequest(ByteString byteString) throws InvalidProtocolBufferException {
        byte[] bytes = byteString.toByteArray();
        return OzoneManagerProtocolProtos.OMRequest.parseFrom(bytes);
    }

    public static Message convertResponseToMessage(OzoneManagerProtocolProtos.OMResponse response) {
        byte[] requestBytes = response.toByteArray();
        return Message.valueOf(ByteString.copyFrom(requestBytes));
    }

    public static OzoneManagerProtocolProtos.OMResponse getOMResponseFromRaftClientReply(RaftClientReply reply) throws InvalidProtocolBufferException {
        byte[] bytes = reply.getMessage().getContent().toByteArray();
        return OzoneManagerProtocolProtos.OMResponse.newBuilder(OzoneManagerProtocolProtos.OMResponse.parseFrom(bytes)).setLeaderOMNodeId(reply.getReplierId()).build();
    }

    public static String smProtoToString(RaftProtos.StateMachineLogEntryProto proto) {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(TextFormat.shortDebugString(OMRatisHelper.convertByteStringToOMRequest(proto.getLogData())));
        }
        catch (Throwable ex) {
            LOG.info("smProtoToString failed", ex);
            builder.append("smProtoToString failed with");
            builder.append(ex.getMessage());
        }
        return builder.toString();
    }
}

