/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.ha.OMProxyInfo;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFailoverProxyProvider
implements FailoverProxyProvider<OzoneManagerProtocolPB>,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(OMFailoverProxyProvider.class);
    private Map<String, FailoverProxyProvider.ProxyInfo<OzoneManagerProtocolPB>> omProxies;
    private Map<String, OMProxyInfo> omProxyInfos;
    private List<String> omNodeIDList;
    private String currentProxyOMNodeId;
    private int currentProxyIndex;
    private final Configuration conf;
    private final long omVersion;
    private final UserGroupInformation ugi;
    private final Text delegationTokenService;
    private final String omServiceId;

    public OMFailoverProxyProvider(OzoneConfiguration configuration, UserGroupInformation ugi, String omServiceId) throws IOException {
        this.conf = configuration;
        this.omVersion = RPC.getProtocolVersion(OzoneManagerProtocolPB.class);
        this.ugi = ugi;
        this.omServiceId = omServiceId;
        this.loadOMClientConfigs(this.conf, this.omServiceId);
        this.delegationTokenService = this.computeDelegationTokenService();
        this.currentProxyIndex = 0;
        this.currentProxyOMNodeId = this.omNodeIDList.get(this.currentProxyIndex);
    }

    public OMFailoverProxyProvider(OzoneConfiguration configuration, UserGroupInformation ugi) throws IOException {
        this(configuration, ugi, null);
    }

    private void loadOMClientConfigs(Configuration config, String omSvcId) throws IOException {
        this.omProxies = new HashMap<String, FailoverProxyProvider.ProxyInfo<OzoneManagerProtocolPB>>();
        this.omProxyInfos = new HashMap<String, OMProxyInfo>();
        this.omNodeIDList = new ArrayList<String>();
        List<String> omServiceIds = Collections.singletonList(omSvcId);
        for (String serviceId : OmUtils.emptyAsSingletonNull(omServiceIds)) {
            Collection<String> omNodeIds = OmUtils.getOMNodeIds(config, serviceId);
            for (String nodeId : OmUtils.emptyAsSingletonNull(omNodeIds)) {
                String rpcAddrKey = OmUtils.addKeySuffixes("ozone.om.address", serviceId, nodeId);
                String rpcAddrStr = OmUtils.getOmRpcAddress(config, rpcAddrKey);
                if (rpcAddrStr == null) continue;
                OMProxyInfo omProxyInfo = new OMProxyInfo(serviceId, nodeId, rpcAddrStr);
                if (omProxyInfo.getAddress() != null) {
                    FailoverProxyProvider.ProxyInfo proxyInfo = new FailoverProxyProvider.ProxyInfo(null, omProxyInfo.toString());
                    if (nodeId == null) {
                        nodeId = "omNodeIdDummy";
                    }
                    this.omProxies.put(nodeId, (FailoverProxyProvider.ProxyInfo<OzoneManagerProtocolPB>)proxyInfo);
                    this.omProxyInfos.put(nodeId, omProxyInfo);
                    this.omNodeIDList.add(nodeId);
                    continue;
                }
                LOG.error("Failed to create OM proxy for {} at address {}", (Object)nodeId, (Object)rpcAddrStr);
            }
        }
        if (this.omProxies.isEmpty()) {
            throw new IllegalArgumentException("Could not find any configured addresses for OM. Please configure the system with ozone.om.address");
        }
    }

    @VisibleForTesting
    public synchronized String getCurrentProxyOMNodeId() {
        return this.currentProxyOMNodeId;
    }

    private OzoneManagerProtocolPB createOMProxy(InetSocketAddress omAddress) throws IOException {
        RPC.setProtocolEngine((Configuration)this.conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        return (OzoneManagerProtocolPB)RPC.getProxy(OzoneManagerProtocolPB.class, (long)this.omVersion, (InetSocketAddress)omAddress, (UserGroupInformation)this.ugi, (Configuration)this.conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)this.conf), (int)Client.getRpcTimeout((Configuration)this.conf));
    }

    public synchronized FailoverProxyProvider.ProxyInfo getProxy() {
        FailoverProxyProvider.ProxyInfo<OzoneManagerProtocolPB> currentProxyInfo = this.omProxies.get(this.currentProxyOMNodeId);
        this.createOMProxyIfNeeded(currentProxyInfo, this.currentProxyOMNodeId);
        return currentProxyInfo;
    }

    private void createOMProxyIfNeeded(FailoverProxyProvider.ProxyInfo proxyInfo, String nodeId) {
        if (proxyInfo.proxy == null) {
            InetSocketAddress address = this.omProxyInfos.get(nodeId).getAddress();
            try {
                proxyInfo.proxy = this.createOMProxy(address);
            }
            catch (IOException ioe) {
                LOG.error("{} Failed to create RPC proxy to OM at {}", new Object[]{this.getClass().getSimpleName(), address, ioe});
                throw new RuntimeException(ioe);
            }
        }
    }

    public Text getCurrentProxyDelegationToken() {
        return this.delegationTokenService;
    }

    private Text computeDelegationTokenService() {
        StringBuilder rpcAddress = new StringBuilder();
        for (Map.Entry<String, OMProxyInfo> omProxyInfoSet : this.omProxyInfos.entrySet()) {
            Text dtService = omProxyInfoSet.getValue().getDelegationTokenService();
            if (dtService == null) continue;
            rpcAddress.append(",").append(dtService);
        }
        return new Text(rpcAddress.toString().substring(1));
    }

    public Class<OzoneManagerProtocolPB> getInterface() {
        return OzoneManagerProtocolPB.class;
    }

    public void performFailover(OzoneManagerProtocolPB currentProxy) {
        if (LOG.isDebugEnabled()) {
            int currentIndex = this.getCurrentProxyIndex();
            LOG.debug("Failing over OM proxy to index: {}, nodeId: {}", (Object)currentIndex, (Object)this.omNodeIDList.get(currentIndex));
        }
    }

    public void performFailoverIfRequired(String newLeaderOMNodeId) {
        if (newLeaderOMNodeId == null) {
            LOG.debug("No suggested leader nodeId. Performing failover to next peer node");
            this.performFailoverToNextProxy();
        } else if (this.updateLeaderOMNodeId(newLeaderOMNodeId)) {
            LOG.debug("Failing over OM proxy to nodeId: {}", (Object)newLeaderOMNodeId);
        }
    }

    public void performFailoverToNextProxy() {
        int newProxyIndex = this.incrementProxyIndex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incrementing OM proxy index to {}, nodeId: {}", (Object)newProxyIndex, (Object)this.omNodeIDList.get(newProxyIndex));
        }
    }

    private synchronized int incrementProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.omProxies.size();
        this.currentProxyOMNodeId = this.omNodeIDList.get(this.currentProxyIndex);
        return this.currentProxyIndex;
    }

    synchronized boolean updateLeaderOMNodeId(String newLeaderOMNodeId) {
        if (!this.currentProxyOMNodeId.equals(newLeaderOMNodeId) && this.omProxies.containsKey(newLeaderOMNodeId)) {
            this.currentProxyOMNodeId = newLeaderOMNodeId;
            this.currentProxyIndex = this.omNodeIDList.indexOf(this.currentProxyOMNodeId);
            return true;
        }
        return false;
    }

    private synchronized int getCurrentProxyIndex() {
        return this.currentProxyIndex;
    }

    @Override
    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo<OzoneManagerProtocolPB> proxy : this.omProxies.values()) {
            OzoneManagerProtocolPB omProxy = (OzoneManagerProtocolPB)proxy.proxy;
            if (omProxy == null) continue;
            RPC.stopProxy((Object)omProxy);
        }
    }

    @VisibleForTesting
    public List<FailoverProxyProvider.ProxyInfo> getOMProxies() {
        return new ArrayList<FailoverProxyProvider.ProxyInfo>(this.omProxies.values());
    }

    @VisibleForTesting
    public List<OMProxyInfo> getOMProxyInfos() {
        return new ArrayList<OMProxyInfo>(this.omProxyInfos.values());
    }
}

