/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class TokenIdentifierCodec
implements Codec<OzoneTokenIdentifier> {
    @Override
    public byte[] toPersistedFormat(OzoneTokenIdentifier object) {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getBytes();
    }

    @Override
    public OzoneTokenIdentifier fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return OzoneTokenIdentifier.readProtoBuf(rawData);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public OzoneTokenIdentifier copyObject(OzoneTokenIdentifier object) {
        return object;
    }
}

