/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class S3SecretValueCodec
implements Codec<S3SecretValue> {
    @Override
    public byte[] toPersistedFormat(S3SecretValue object) throws IOException {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getProtobuf().toByteArray();
    }

    @Override
    public S3SecretValue fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return S3SecretValue.fromProtobuf(OzoneManagerProtocolProtos.S3Secret.parseFrom(rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public S3SecretValue copyObject(S3SecretValue object) {
        return object;
    }
}

