/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class RepeatedOmKeyInfoCodec
implements Codec<RepeatedOmKeyInfo> {
    @Override
    public byte[] toPersistedFormat(RepeatedOmKeyInfo object) throws IOException {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getProto().toByteArray();
    }

    @Override
    public RepeatedOmKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return RepeatedOmKeyInfo.getFromProto(OzoneManagerProtocolProtos.RepeatedKeyInfo.parseFrom(rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public RepeatedOmKeyInfo copyObject(RepeatedOmKeyInfo object) {
        return object;
    }
}

