/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class OmPrefixInfoCodec
implements Codec<OmPrefixInfo> {
    @Override
    public byte[] toPersistedFormat(OmPrefixInfo object) throws IOException {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getProtobuf().toByteArray();
    }

    @Override
    public OmPrefixInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return OmPrefixInfo.getFromProtobuf(OzoneManagerProtocolProtos.PrefixInfo.parseFrom(rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public OmPrefixInfo copyObject(OmPrefixInfo object) {
        return object.copyObject();
    }
}

