/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class OmMultipartKeyInfoCodec
implements Codec<OmMultipartKeyInfo> {
    @Override
    public byte[] toPersistedFormat(OmMultipartKeyInfo object) throws IOException {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getProto().toByteArray();
    }

    @Override
    public OmMultipartKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return OmMultipartKeyInfo.getFromProto(OzoneManagerProtocolProtos.MultipartKeyInfo.parseFrom(rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public OmMultipartKeyInfo copyObject(OmMultipartKeyInfo object) {
        return object.copyObject();
    }
}

