/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class OmKeyInfoCodec
implements Codec<OmKeyInfo> {
    @Override
    public byte[] toPersistedFormat(OmKeyInfo object) throws IOException {
        Preconditions.checkNotNull(object, "Null object can't be converted to byte array.");
        return object.getProtobuf().toByteArray();
    }

    @Override
    public OmKeyInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull(rawData, "Null byte array can't converted to real object.");
        try {
            return OmKeyInfo.getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo.parseFrom(rawData));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    @Override
    public OmKeyInfo copyObject(OmKeyInfo omKeyInfo) {
        return omKeyInfo.copyObject();
    }
}

