/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.OzoneSecurityException;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3SecretManagerImpl
implements S3SecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3SecretManagerImpl.class);
    private final OMMetadataManager omMetadataManager;
    private final OzoneConfiguration configuration;

    public S3SecretManagerImpl(OzoneConfiguration configuration, OMMetadataManager omMetadataManager) {
        this.configuration = configuration;
        this.omMetadataManager = omMetadataManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        S3SecretValue result;
        block4: {
            S3SecretValue s3SecretValue;
            Preconditions.checkArgument(Strings.isNotBlank((String)kerberosID), "kerberosID cannot be null or empty.");
            result = null;
            this.omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
            try {
                S3SecretValue s3Secret = this.omMetadataManager.getS3SecretTable().get(kerberosID);
                if (s3Secret == null) {
                    byte[] secret = OmUtils.getSHADigest();
                    result = new S3SecretValue(kerberosID, DigestUtils.sha256Hex(secret));
                    this.omMetadataManager.getS3SecretTable().put(kerberosID, result);
                    break block4;
                }
                s3SecretValue = s3Secret;
            }
            catch (Throwable throwable) {
                this.omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
                throw throwable;
            }
            this.omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
            return s3SecretValue;
        }
        this.omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Secret for accessKey:{}, proto:{}", (Object)kerberosID, (Object)result);
        }
        return result;
    }

    @Override
    public String getS3UserSecretString(String kerberosID) throws IOException {
        S3SecretValue s3Secret;
        Preconditions.checkArgument(Strings.isNotBlank((String)kerberosID), "awsAccessKeyId cannot be null or empty.");
        LOG.trace("Get secret for awsAccessKey:{}", (Object)kerberosID);
        this.omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
        try {
            s3Secret = this.omMetadataManager.getS3SecretTable().get(kerberosID);
            if (s3Secret == null) {
                throw new OzoneSecurityException("S3 secret not found for awsAccessKeyId " + kerberosID, OzoneSecurityException.ResultCodes.S3_SECRET_NOT_FOUND);
            }
        }
        catch (Throwable throwable) {
            this.omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
            throw throwable;
        }
        this.omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.S3_SECRET_LOCK, kerberosID);
        return s3Secret.getAwsSecret();
    }

    public OMMetadataManager getOmMetadataManager() {
        return this.omMetadataManager;
    }
}

