/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.lock.LockManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Daemon;
import org.junit.Assert;
import org.junit.Test;

public class TestLockManager {
    @Test(timeout=1000L)
    public void testWriteLockWithDifferentResource() {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        manager.writeLock("/resourceOne");
        manager.writeLock("/resourceTwo");
        manager.writeUnlock("/resourceOne");
        manager.writeUnlock("/resourceTwo");
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testWriteLockWithSameResource() throws Exception {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.writeLock("/resourceOne");
        new Thread(() -> {
            manager.writeLock("/resourceOne");
            gotLock.set(true);
            manager.writeUnlock("/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assert.assertFalse((boolean)gotLock.get());
        manager.writeUnlock("/resourceOne");
        Thread.sleep(100L);
        Assert.assertTrue((boolean)gotLock.get());
    }

    @Test(timeout=1000L)
    public void testReadLockWithDifferentResource() {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        manager.readLock("/resourceOne");
        manager.readLock("/resourceTwo");
        manager.readUnlock("/resourceOne");
        manager.readUnlock("/resourceTwo");
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testReadLockWithSameResource() throws Exception {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock("/resourceOne");
        new Thread(() -> {
            manager.readLock("/resourceOne");
            gotLock.set(true);
            manager.readUnlock("/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assert.assertTrue((boolean)gotLock.get());
        manager.readUnlock("/resourceOne");
    }

    @Test
    public void testWriteReadLockWithSameResource() throws Exception {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.writeLock("/resourceOne");
        new Thread(() -> {
            manager.readLock("/resourceOne");
            gotLock.set(true);
            manager.readUnlock("/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assert.assertFalse((boolean)gotLock.get());
        manager.writeUnlock("/resourceOne");
        Thread.sleep(100L);
        Assert.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testReadWriteLockWithSameResource() throws Exception {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock("/resourceOne");
        new Thread(() -> {
            manager.writeLock("/resourceOne");
            gotLock.set(true);
            manager.writeUnlock("/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assert.assertFalse((boolean)gotLock.get());
        manager.readUnlock("/resourceOne");
        Thread.sleep(100L);
        Assert.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testMultiReadWriteLockWithSameResource() throws Exception {
        LockManager<String> manager = new LockManager<String>(new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock("/resourceOne");
        manager.readLock("/resourceOne");
        new Thread(() -> {
            manager.writeLock("/resourceOne");
            gotLock.set(true);
            manager.writeUnlock("/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assert.assertFalse((boolean)gotLock.get());
        manager.readUnlock("/resourceOne");
        Thread.sleep(100L);
        Assert.assertFalse((boolean)gotLock.get());
        manager.readUnlock("/resourceOne");
        Thread.sleep(100L);
        Assert.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testConcurrentWriteLockWithDifferentResource() throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        int count = 100;
        LockManager manager = new LockManager(conf);
        int sleep = 10;
        AtomicInteger done = new AtomicInteger();
        for (int i = 0; i < 100; ++i) {
            Integer id = i;
            Daemon d1 = new Daemon(() -> {
                try {
                    manager.writeLock(id);
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    manager.writeUnlock(id);
                }
                done.getAndIncrement();
            });
            d1.setName("Locker-" + i);
            d1.start();
        }
        GenericTestUtils.waitFor(() -> done.get() == 100, (int)100, (int)10000);
        Assert.assertEquals((long)100L, (long)done.get());
    }
}

