/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.HashMap;
import org.apache.hadoop.ozone.lease.Lease;
import org.apache.hadoop.ozone.lease.LeaseAlreadyExistException;
import org.apache.hadoop.ozone.lease.LeaseException;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseNotFoundException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestLeaseManager {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testLeaseAcquireAndRelease() throws LeaseException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Lease<DummyResource> leaseTwo = manager.acquire(resourceTwo);
        Lease<DummyResource> leaseThree = manager.acquire(resourceThree);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertEquals(leaseTwo, manager.get(resourceTwo));
        Assert.assertEquals(leaseThree, manager.get(resourceThree));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        manager.release(resourceOne);
        manager.release(resourceTwo);
        manager.release(resourceThree);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testLeaseAlreadyExist() throws LeaseException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Lease<DummyResource> leaseTwo = manager.acquire(resourceTwo);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertEquals(leaseTwo, manager.get(resourceTwo));
        this.exception.expect(LeaseAlreadyExistException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.acquire(resourceOne);
        manager.release(resourceOne);
        manager.release(resourceTwo);
        manager.shutdown();
    }

    @Test
    public void testLeaseNotFound() throws LeaseException, InterruptedException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get(resourceOne);
        Lease<DummyResource> leaseTwo = manager.acquire(resourceTwo);
        Assert.assertEquals(leaseTwo, manager.get(resourceTwo));
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        manager.release(resourceTwo);
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceTwo);
        manager.get(resourceTwo);
        Lease<DummyResource> leaseThree = manager.acquire(resourceThree);
        Assert.assertEquals(leaseThree, manager.get(resourceThree));
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        long sleepTime = leaseThree.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceThree);
        manager.get(resourceThree);
        manager.shutdown();
    }

    @Test
    public void testCustomLeaseTimeout() throws LeaseException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Lease<DummyResource> leaseTwo = manager.acquire(resourceTwo, 10000L);
        Lease<DummyResource> leaseThree = manager.acquire(resourceThree, 50000L);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertEquals(leaseTwo, manager.get(resourceTwo));
        Assert.assertEquals(leaseThree, manager.get(resourceThree));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        Assert.assertFalse((boolean)leaseTwo.hasExpired());
        Assert.assertFalse((boolean)leaseThree.hasExpired());
        Assert.assertEquals((long)5000L, (long)leaseOne.getLeaseLifeTime());
        Assert.assertEquals((long)10000L, (long)leaseTwo.getLeaseLifeTime());
        Assert.assertEquals((long)50000L, (long)leaseThree.getLeaseLifeTime());
        manager.shutdown();
    }

    @Test
    public void testLeaseCallback() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        leaseStatus.put(resourceOne, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get(resourceOne);
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceOne));
    }

    @Test
    public void testCallbackExecutionInCaseOfLeaseRelease() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        leaseStatus.put(resourceOne, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease released");
        manager.release(resourceOne);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        this.exception.expect(LeaseNotFoundException.class);
        this.exception.expectMessage("Resource: " + resourceOne);
        manager.get(resourceOne);
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
    }

    @Test
    public void testLeaseCallbackWithMultipleLeases() throws LeaseException, InterruptedException {
        HashMap<DummyResource, String> leaseStatus = new HashMap<DummyResource, String>();
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        DummyResource resourceTwo = new DummyResource("two");
        DummyResource resourceThree = new DummyResource("three");
        DummyResource resourceFour = new DummyResource("four");
        DummyResource resourceFive = new DummyResource("five");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Lease<DummyResource> leaseTwo = manager.acquire(resourceTwo);
        Lease<DummyResource> leaseThree = manager.acquire(resourceThree);
        Lease<DummyResource> leaseFour = manager.acquire(resourceFour);
        Lease<DummyResource> leaseFive = manager.acquire(resourceFive);
        leaseStatus.put(resourceOne, "lease in use");
        leaseStatus.put(resourceTwo, "lease in use");
        leaseStatus.put(resourceThree, "lease in use");
        leaseStatus.put(resourceFour, "lease in use");
        leaseStatus.put(resourceFive, "lease in use");
        leaseOne.registerCallBack(() -> {
            leaseStatus.put(resourceOne, "lease expired");
            return null;
        });
        leaseTwo.registerCallBack(() -> {
            leaseStatus.put(resourceTwo, "lease expired");
            return null;
        });
        leaseThree.registerCallBack(() -> {
            leaseStatus.put(resourceThree, "lease expired");
            return null;
        });
        leaseFour.registerCallBack(() -> {
            leaseStatus.put(resourceFour, "lease expired");
            return null;
        });
        leaseFive.registerCallBack(() -> {
            leaseStatus.put(resourceFive, "lease expired");
            return null;
        });
        leaseStatus.put(resourceOne, "lease released");
        manager.release(resourceOne);
        leaseStatus.put(resourceTwo, "lease released");
        manager.release(resourceTwo);
        leaseStatus.put(resourceThree, "lease released");
        manager.release(resourceThree);
        long sleepTime = leaseFive.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Assert.assertTrue((boolean)leaseTwo.hasExpired());
        Assert.assertTrue((boolean)leaseThree.hasExpired());
        Assert.assertTrue((boolean)leaseFour.hasExpired());
        Assert.assertTrue((boolean)leaseFive.hasExpired());
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceOne));
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceTwo));
        Assert.assertEquals((Object)"lease released", leaseStatus.get(resourceThree));
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceFour));
        Assert.assertEquals((Object)"lease expired", leaseStatus.get(resourceFive));
        manager.shutdown();
    }

    @Test
    public void testReuseReleasedLease() throws LeaseException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        manager.release(resourceOne);
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Lease<DummyResource> sameResourceLease = manager.acquire(resourceOne);
        Assert.assertEquals(sameResourceLease, manager.get(resourceOne));
        Assert.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release(resourceOne);
        Assert.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testReuseTimedOutLease() throws LeaseException, InterruptedException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        long sleepTime = leaseOne.getRemainingTime() + 1000L;
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.sleep(sleepTime);
        }
        Assert.assertTrue((boolean)leaseOne.hasExpired());
        Lease<DummyResource> sameResourceLease = manager.acquire(resourceOne);
        Assert.assertEquals(sameResourceLease, manager.get(resourceOne));
        Assert.assertFalse((boolean)sameResourceLease.hasExpired());
        manager.release(resourceOne);
        Assert.assertTrue((boolean)sameResourceLease.hasExpired());
        manager.shutdown();
    }

    @Test
    public void testRenewLease() throws LeaseException, InterruptedException {
        LeaseManager<DummyResource> manager = new LeaseManager<DummyResource>("Test", 5000L);
        manager.start();
        DummyResource resourceOne = new DummyResource("one");
        Lease<DummyResource> leaseOne = manager.acquire(resourceOne);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        leaseOne.renew(5000L);
        Thread.sleep(5000L);
        Assert.assertEquals(leaseOne, manager.get(resourceOne));
        Assert.assertFalse((boolean)leaseOne.hasExpired());
        manager.release(resourceOne);
        manager.shutdown();
    }

    private static final class DummyResource {
        private final String name;

        private DummyResource(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DummyResource) {
                return this.name.equals(((DummyResource)obj).name);
            }
            return false;
        }

        public String toString() {
            return "DummyResource{name='" + this.name + '\'' + '}';
        }
    }
}

