/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;

public class ReplicationTask {
    private volatile Status status = Status.QUEUED;
    private final long containerId;
    private List<DatanodeDetails> sources;
    private final Instant queued = Instant.now();

    public ReplicationTask(long containerId, List<DatanodeDetails> sources) {
        this.containerId = containerId;
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationTask that = (ReplicationTask)o;
        return this.containerId == that.containerId;
    }

    public int hashCode() {
        return Objects.hash(this.containerId);
    }

    public long getContainerId() {
        return this.containerId;
    }

    public List<DatanodeDetails> getSources() {
        return this.sources;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "ReplicationTask{status=" + (Object)((Object)this.status) + ", containerId=" + this.containerId + ", sources=" + this.sources + ", queued=" + this.queued + '}';
    }

    public Instant getQueued() {
        return this.queued;
    }

    public static enum Status {
        QUEUED,
        DOWNLOADING,
        FAILED,
        DONE;

    }
}

