/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.GrpcOutputStream;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationService
extends IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationService.class);
    private static final int BUFFER_SIZE = 0x100000;
    private final ContainerReplicationSource source;

    public GrpcReplicationService(ContainerReplicationSource source) {
        this.source = source;
    }

    @Override
    public void download(ContainerProtos.CopyContainerRequestProto request, StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver) {
        long containerID = request.getContainerID();
        LOG.info("Streaming container data ({}) to other datanode", (Object)containerID);
        try {
            GrpcOutputStream outputStream = new GrpcOutputStream(responseObserver, containerID, 0x100000);
            this.source.copyData(containerID, outputStream);
        }
        catch (IOException e) {
            LOG.error("Error streaming container {}", (Object)containerID, (Object)e);
            responseObserver.onError(e);
        }
    }
}

