/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationClient {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationClient.class);
    private final ManagedChannel channel;
    private final IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceStub client;
    private final Path workingDirectory;

    public GrpcReplicationClient(String host, int port, Path workingDir) {
        this.channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(host, port).usePlaintext().maxInboundMessageSize(0x2000000)).build();
        this.client = IntraDatanodeProtocolServiceGrpc.newStub(this.channel);
        this.workingDirectory = workingDir;
    }

    public CompletableFuture<Path> download(long containerId) {
        ContainerProtos.CopyContainerRequestProto request = ContainerProtos.CopyContainerRequestProto.newBuilder().setContainerID(containerId).setLen(-1L).setReadOffset(0L).build();
        CompletableFuture<Path> response = new CompletableFuture<Path>();
        Path destinationPath = this.getWorkingDirectory().resolve("container-" + containerId + ".tar.gz");
        this.client.download(request, new StreamDownloader(containerId, response, destinationPath));
        return response;
    }

    private Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void shutdown() {
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("failed to shutdown replication channel", (Throwable)e);
        }
    }

    public static class StreamDownloader
    implements StreamObserver<ContainerProtos.CopyContainerResponseProto> {
        private final CompletableFuture<Path> response;
        private final long containerId;
        private final OutputStream stream;
        private final Path outputPath;

        public StreamDownloader(long containerId, CompletableFuture<Path> response, Path outputPath) {
            this.response = response;
            this.containerId = containerId;
            this.outputPath = outputPath;
            try {
                Preconditions.checkNotNull(outputPath, "Output path cannot be null");
                Path parentPath = Preconditions.checkNotNull(outputPath.getParent());
                Files.createDirectories(parentPath, new FileAttribute[0]);
                this.stream = new FileOutputStream(outputPath.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Output path can't be used: " + outputPath, e);
            }
        }

        @Override
        public void onNext(ContainerProtos.CopyContainerResponseProto chunk) {
            try {
                chunk.getData().writeTo(this.stream);
            }
            catch (IOException e) {
                this.response.completeExceptionally(e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            try {
                LOG.error("Download of container {} was unsuccessful", (Object)this.containerId, (Object)throwable);
                this.stream.close();
                this.deleteOutputOnFailure();
                this.response.completeExceptionally(throwable);
            }
            catch (IOException e) {
                LOG.error("Failed to close {} for container {}", new Object[]{this.outputPath, this.containerId, e});
                this.response.completeExceptionally(e);
            }
        }

        @Override
        public void onCompleted() {
            try {
                this.stream.close();
                LOG.info("Container {} is downloaded to {}", (Object)this.containerId, (Object)this.outputPath);
                this.response.complete(this.outputPath);
            }
            catch (IOException e) {
                LOG.error("Downloaded container {} OK, but failed to close {}", new Object[]{this.containerId, this.outputPath, e});
                this.response.completeExceptionally(e);
            }
        }

        private void deleteOutputOnFailure() {
            try {
                Files.delete(this.outputPath);
            }
            catch (IOException ex) {
                LOG.error("Failed to delete temporary destination {} for unsuccessful download of container {}", new Object[]{this.outputPath, this.containerId, ex});
            }
        }
    }
}

