/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueBlockIterator;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.primitives.Longs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReader
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReader.class);
    private HddsVolume hddsVolume;
    private final ContainerSet containerSet;
    private final OzoneConfiguration config;
    private final File hddsVolumeDir;
    private final MutableVolumeSet volumeSet;

    ContainerReader(MutableVolumeSet volSet, HddsVolume volume, ContainerSet cset, OzoneConfiguration conf) {
        Preconditions.checkNotNull(volume);
        this.hddsVolume = volume;
        this.hddsVolumeDir = this.hddsVolume.getHddsRootDir();
        this.containerSet = cset;
        this.config = conf;
        this.volumeSet = volSet;
    }

    @Override
    public void run() {
        try {
            this.readVolume(this.hddsVolumeDir);
        }
        catch (RuntimeException ex) {
            LOG.error("Caught a Run time exception during reading container files from Volume {} {}", (Object)this.hddsVolumeDir, (Object)ex);
        }
    }

    public void readVolume(File hddsVolumeRootDir) {
        Preconditions.checkNotNull(hddsVolumeRootDir, "hddsVolumeRootDircannot be null");
        File[] scmDir = hddsVolumeRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (scmDir == null) {
            LOG.error("IO error for the volume {}, skipped loading", (Object)hddsVolumeRootDir);
            this.volumeSet.failVolume(hddsVolumeRootDir.getPath());
            return;
        }
        if (scmDir.length > 1) {
            LOG.error("Volume {} is in Inconsistent state", (Object)hddsVolumeRootDir);
            this.volumeSet.failVolume(hddsVolumeRootDir.getPath());
            return;
        }
        for (File scmLoc : scmDir) {
            File currentDir = new File(scmLoc, "current");
            File[] containerTopDirs = currentDir.listFiles();
            if (containerTopDirs == null) continue;
            for (File containerTopDir : containerTopDirs) {
                File[] containerDirs;
                if (!containerTopDir.isDirectory() || (containerDirs = containerTopDir.listFiles()) == null) continue;
                for (File containerDir : containerDirs) {
                    File containerFile = ContainerUtils.getContainerFile(containerDir);
                    long containerID = ContainerUtils.getContainerID(containerDir);
                    if (containerFile.exists()) {
                        this.verifyContainerFile(containerID, containerFile);
                        continue;
                    }
                    LOG.error("Missing .container file for ContainerID: {}", (Object)containerDir.getName());
                }
            }
        }
    }

    private void verifyContainerFile(long containerID, File containerFile) {
        try {
            ContainerData containerData = ContainerDataYaml.readContainerFile(containerFile);
            if (containerID != containerData.getContainerID()) {
                LOG.error("Invalid ContainerID in file {}. Skipping loading of this container.", (Object)containerFile);
                return;
            }
            this.verifyAndFixupContainerData(containerData);
        }
        catch (IOException ex) {
            LOG.error("Failed to parse ContainerFile for ContainerID: {}", (Object)containerID, (Object)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void verifyAndFixupContainerData(ContainerData containerData) throws IOException {
        switch (2.$SwitchMap$org$apache$hadoop$hdds$protocol$datanode$proto$ContainerProtos$ContainerType[containerData.getContainerType().ordinal()]) {
            case 1: {
                if (!(containerData instanceof KeyValueContainerData)) ** GOTO lbl48
                kvContainerData = (KeyValueContainerData)containerData;
                containerData.setVolume(this.hddsVolume);
                KeyValueContainerUtil.parseKVContainerData(kvContainerData, this.config);
                kvContainer = new KeyValueContainer(kvContainerData, this.config);
                containerDB = BlockUtils.getDB(kvContainerData, this.config);
                var5_5 = null;
                filter = new MetadataKeyFilters.KeyPrefixFilter().addFilter("#deleting#");
                numPendingDeletionBlocks = containerDB.getStore().getSequentialRangeKVs(null, 0x7FFFFFFF, new MetadataKeyFilters.MetadataKeyFilter[]{filter}).size();
                kvContainerData.incrPendingDeletionBlocks(numPendingDeletionBlocks);
                delTxnId = containerDB.getStore().get(DFSUtil.string2Bytes((String)"#delTX#"));
                if (delTxnId != null) {
                    kvContainerData.updateDeleteTransactionId(Longs.fromByteArray(delTxnId));
                }
                if ((bcsId = containerDB.getStore().get(DFSUtil.string2Bytes((String)"#BCSID"))) != null) {
                    kvContainerData.updateBlockCommitSequenceId(Longs.fromByteArray(bcsId));
                }
                if (kvContainer.getContainerState() == ContainerProtos.ContainerDataProto.State.OPEN) {
                    this.initializeUsedBytes(kvContainer);
                }
                this.containerSet.addContainer(kvContainer);
                if (containerDB == null) break;
                if (var5_5 == null) ** GOTO lbl31
                try {
                    containerDB.close();
                }
                catch (Throwable var6_7) {
                    var5_5.addSuppressed(var6_7);
                }
                break;
lbl31:
                // 1 sources

                containerDB.close();
                break;
                catch (Throwable var6_8) {
                    try {
                        var5_5 = var6_8;
                        throw var6_8;
                    }
                    catch (Throwable var10_12) {
                        if (containerDB != null) {
                            if (var5_5 != null) {
                                try {
                                    containerDB.close();
                                }
                                catch (Throwable var11_13) {
                                    var5_5.addSuppressed(var11_13);
                                }
                            } else {
                                containerDB.close();
                            }
                        }
                        throw var10_12;
                    }
                }
lbl48:
                // 1 sources

                throw new StorageContainerException("Container File is corrupted. ContainerType is KeyValueContainer but cast to KeyValueContainerData failed. ", ContainerProtos.Result.CONTAINER_METADATA_ERROR);
            }
            default: {
                throw new StorageContainerException("Unrecognized ContainerType " + containerData.getContainerType(), ContainerProtos.Result.UNKNOWN_CONTAINER_TYPE);
            }
        }
    }

    private void initializeUsedBytes(KeyValueContainer container) throws IOException {
        try (KeyValueBlockIterator blockIter = new KeyValueBlockIterator(container.getContainerData().getContainerID(), new File(container.getContainerData().getContainerPath()));){
            long usedBytes = 0L;
            while (blockIter.hasNext()) {
                BlockData block = blockIter.nextBlock();
                long blockLen = 0L;
                List<ContainerProtos.ChunkInfo> chunkInfoList = block.getChunks();
                for (ContainerProtos.ChunkInfo chunk : chunkInfoList) {
                    ChunkInfo info = ChunkInfo.getFromProtoBuf(chunk);
                    blockLen += info.getLen();
                }
                usedBytes += blockLen;
            }
            container.getContainerData().setBytesUsed(usedBytes);
        }
    }
}

