/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.statemachine.background;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.BatchOperation;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.TopNOrderedContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDeletingService.class);
    private OzoneContainer ozoneContainer;
    private ContainerDeletionChoosingPolicy containerDeletionPolicy;
    private final Configuration conf;
    private final int blockLimitPerTask;
    private final int containerLimitPerInterval;
    private static final int TASK_PRIORITY_DEFAULT = 1;
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 10;

    public BlockDeletingService(OzoneContainer ozoneContainer, long serviceInterval, long serviceTimeout, TimeUnit timeUnit, Configuration conf) {
        super("BlockDeletingService", serviceInterval, timeUnit, 10, serviceTimeout);
        this.ozoneContainer = ozoneContainer;
        this.containerDeletionPolicy = (ContainerDeletionChoosingPolicy)ReflectionUtils.newInstance((Class)conf.getClass("ozone.scm.keyvalue.container.deletion-choosing.policy", TopNOrderedContainerDeletionChoosingPolicy.class, ContainerDeletionChoosingPolicy.class), (Configuration)conf);
        this.conf = conf;
        this.blockLimitPerTask = conf.getInt("ozone.block.deleting.limit.per.task", 1000);
        this.containerLimitPerInterval = conf.getInt("ozone.block.deleting.container.limit.per.interval", 10);
    }

    @Override
    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue;
        block5: {
            queue = new BackgroundTaskQueue();
            List<Object> containers = Lists.newArrayList();
            try {
                containers = this.chooseContainerForBlockDeletion(this.containerLimitPerInterval, this.containerDeletionPolicy);
                if (containers.size() > 0) {
                    LOG.info("Plan to choose {} containers for block deletion, actually returns {} valid containers.", (Object)this.containerLimitPerInterval, (Object)containers.size());
                }
                for (ContainerData containerData : containers) {
                    BlockDeletingTask containerTask = new BlockDeletingTask(containerData, 1);
                    queue.add(containerTask);
                }
            }
            catch (StorageContainerException e) {
                LOG.warn("Failed to initiate block deleting tasks, caused by unable to get containers info. Retry in next interval. ", (Throwable)e);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Unexpected error occurs during deleting blocks.", (Throwable)e);
            }
        }
        return queue;
    }

    public List<ContainerData> chooseContainerForBlockDeletion(int count, ContainerDeletionChoosingPolicy deletionPolicy) throws StorageContainerException {
        Map<Long, ContainerData> containerDataMap = this.ozoneContainer.getContainerSet().getContainerMap().entrySet().stream().filter(e -> this.isDeletionAllowed((ContainerData)((Container)e.getValue()).getContainerData(), deletionPolicy)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Container)e.getValue()).getContainerData()));
        return deletionPolicy.chooseContainerForBlockDeletion(count, containerDataMap);
    }

    private boolean isDeletionAllowed(ContainerData containerData, ContainerDeletionChoosingPolicy deletionPolicy) {
        if (!deletionPolicy.isValidContainerType(containerData.getContainerType())) {
            return false;
        }
        if (!containerData.isClosed()) {
            return false;
        }
        if (this.ozoneContainer.getWriteChannel() instanceof XceiverServerRatis) {
            PipelineID pipelineID;
            XceiverServerRatis ratisServer = (XceiverServerRatis)this.ozoneContainer.getWriteChannel();
            if (!ratisServer.isExist((pipelineID = PipelineID.valueOf(UUID.fromString(containerData.getOriginPipelineId()))).getProtobuf())) {
                return true;
            }
            try {
                long minReplicatedIndex = ratisServer.getMinReplicatedIndex(pipelineID);
                long containerBCSID = containerData.getBlockCommitSequenceId();
                if (minReplicatedIndex >= 0L && minReplicatedIndex < containerBCSID) {
                    LOG.warn("Close Container log Index {} is not replicated across all the servers in the pipeline {} as the min replicated index is {}. Deletion is not allowed in this container yet.", new Object[]{containerBCSID, containerData.getOriginPipelineId(), minReplicatedIndex});
                    return false;
                }
                return true;
            }
            catch (IOException ioe) {
                if (!ratisServer.isExist(pipelineID.getProtobuf())) {
                    return true;
                }
                LOG.info(ioe.getMessage());
                return false;
            }
        }
        return true;
    }

    private class BlockDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private final int priority;
        private final KeyValueContainerData containerData;

        BlockDeletingTask(ContainerData containerName, int priority) {
            this.priority = priority;
            this.containerData = (KeyValueContainerData)containerName;
        }

        /*
         * Loose catch block
         */
        @Override
        public BackgroundTaskResult call() throws Exception {
            ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
            Container<?> container = BlockDeletingService.this.ozoneContainer.getContainerSet().getContainer(this.containerData.getContainerID());
            container.writeLock();
            long startTime = Time.monotonicNow();
            try {
                ContainerBackgroundTaskResult containerBackgroundTaskResult;
                try (ReferenceCountedDB meta = BlockUtils.getDB(this.containerData, BlockDeletingService.this.conf);){
                    MetadataKeyFilters.KeyPrefixFilter filter = new MetadataKeyFilters.KeyPrefixFilter().addFilter("#deleting#");
                    List<Map.Entry<byte[], byte[]>> toDeleteBlocks = meta.getStore().getSequentialRangeKVs(null, BlockDeletingService.this.blockLimitPerTask, filter);
                    if (toDeleteBlocks.isEmpty()) {
                        LOG.debug("No under deletion block found in container : {}", (Object)this.containerData.getContainerID());
                    }
                    LinkedList<String> succeedBlocks = new LinkedList<String>();
                    LOG.debug("Container : {}, To-Delete blocks : {}", (Object)this.containerData.getContainerID(), (Object)toDeleteBlocks.size());
                    File dataDir = new File(this.containerData.getChunksPath());
                    if (!dataDir.exists() || !dataDir.isDirectory()) {
                        LOG.error("Invalid container data dir {} : does not exist or not a directory", (Object)dataDir.getAbsolutePath());
                        ContainerBackgroundTaskResult containerBackgroundTaskResult2 = crr;
                        return containerBackgroundTaskResult2;
                    }
                    Handler handler = Objects.requireNonNull(BlockDeletingService.this.ozoneContainer.getDispatcher().getHandler(container.getContainerType()));
                    toDeleteBlocks.forEach(entry -> {
                        String blockName = DFSUtil.bytes2String((byte[])((byte[])entry.getKey()));
                        LOG.debug("Deleting block {}", (Object)blockName);
                        try {
                            ContainerProtos.BlockData data = ContainerProtos.BlockData.parseFrom((byte[])entry.getValue());
                            handler.deleteBlock(container, BlockData.getFromProtoBuf(data));
                            succeedBlocks.add(blockName);
                        }
                        catch (InvalidProtocolBufferException e) {
                            LOG.error("Failed to parse block info for block {}", (Object)blockName, (Object)e);
                        }
                        catch (IOException e) {
                            LOG.error("Failed to delete files for block {}", (Object)blockName, (Object)e);
                        }
                    });
                    BatchOperation batch = new BatchOperation();
                    succeedBlocks.forEach(entry -> {
                        String blockId = entry.substring("#deleting#".length());
                        String deletedEntry = "#deleted#" + blockId;
                        batch.put(DFSUtil.string2Bytes((String)deletedEntry), DFSUtil.string2Bytes((String)blockId));
                        batch.delete(DFSUtil.string2Bytes((String)entry));
                    });
                    meta.getStore().writeBatch(batch);
                    this.containerData.decrPendingDeletionBlocks(succeedBlocks.size());
                    if (!succeedBlocks.isEmpty()) {
                        LOG.info("Container: {}, deleted blocks: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), succeedBlocks.size(), Time.monotonicNow() - startTime});
                    }
                    crr.addAll(succeedBlocks);
                    containerBackgroundTaskResult = crr;
                }
                return containerBackgroundTaskResult;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                container.writeUnlock();
            }
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    private static class ContainerBackgroundTaskResult
    implements BackgroundTaskResult {
        private List<String> deletedBlockIds = new LinkedList<String>();

        ContainerBackgroundTaskResult() {
        }

        public void addBlockId(String blockId) {
            this.deletedBlockIds.add(blockId);
        }

        public void addAll(List<String> blockIds) {
            this.deletedBlockIds.addAll(blockIds);
        }

        public List<String> getDeletedBlocks() {
            return this.deletedBlockIds;
        }

        @Override
        public int getSize() {
            return this.deletedBlockIds.size();
        }
    }
}

